# Fix Patient Add Error - hospital_id Column Missing

## Problem
Error: `SQLSTATE[42S22]: Column not found: 1054 Unknown column 'hospital_id' in 'field list'`

## Cause
The `patients` table is missing the `hospital_id` column.

## Quick Fix (Choose One Method)

### Method 1: Run PHP Script via Browser (Recommended)
1. Open your browser
2. Go to: `http://localhost/hms_project/fix_patients_hospital_id_simple.php`
3. The script will automatically add the missing column

### Method 2: Run SQL in phpMyAdmin
1. Open phpMyAdmin
2. Select `hms` database
3. Go to SQL tab
4. Copy and paste this SQL:

```sql
USE `hms`;

-- Add hospital_id column if it doesn't exist
ALTER TABLE `patients` 
ADD COLUMN `hospital_id` INT UNSIGNED NULL AFTER `id`;

-- Add index
ALTER TABLE `patients` 
ADD INDEX `idx_patients_hospital` (`hospital_id`);

-- Add foreign key constraint
ALTER TABLE `patients` 
ADD CONSTRAINT `fk_patients_hospital` 
FOREIGN KEY (`hospital_id`) 
REFERENCES `hospitals` (`id`) 
ON DELETE CASCADE;
```

5. Click "Go" to execute

### Method 3: Run add_hospital_id_columns.php (Adds to ALL tables)
1. Open browser
2. Go to: `http://localhost/hms_project/add_hospital_id_columns.php`
3. This will add hospital_id to ALL tables that need it

## Verification
After running the fix, verify:
1. Go to phpMyAdmin
2. Select `hms` database
3. Click on `patients` table
4. Click "Structure" tab
5. You should see `hospital_id` column

## After Fix
Once the column is added:
- Patient add should work correctly
- Each patient will be assigned to the logged-in hospital admin's hospital
- Data isolation will work properly

