<?php
declare(strict_types=1);

final class Auth
{
    public static function check(): bool
    {
        return !empty($_SESSION['admin_user']);
    }

    public static function user(): ?array
    {
        return $_SESSION['admin_user'] ?? null;
    }

    public static function login(array $user): void
    {
        $_SESSION['admin_user'] = [
            'id' => (int)$user['id'],
            'name' => (string)($user['name'] ?? ''),
            'email' => (string)($user['email'] ?? ''),
            'role' => (string)($user['role'] ?? 'admin'),
            'hospital_id' => isset($user['hospital_id']) ? (int)$user['hospital_id'] : null,
        ];
    }

    public static function logout(): void
    {
        unset($_SESSION['admin_user']);
    }
}
