<?php
// Admin routes
$app->get('/', 'DashboardController@index');

// Auth
$app->get('/login', 'AuthController@login');
$app->post('/auth/login', 'AuthController@doLogin');
$app->get('/logout', 'AuthController@logout');

// Patients module
$app->get('/patients', 'PatientsController@index');
$app->get('/patients/add', 'PatientsController@add');
$app->post('/patients/store', 'PatientsController@store');
$app->get('/patients/view', 'PatientsController@show'); // expects ?id=123
$app->get('/patients/edit', 'PatientsController@edit');
$app->post('/patients/update', 'PatientsController@update');
$app->post('/patients/delete', 'PatientsController@delete');
$app->get('/patients/print', 'PatientsController@print');
// Discharge Summary
$app->get('/patients/discharge-summary', 'PatientsController@dischargeSummary');
$app->post('/patients/addDischargeSummary', 'PatientsController@addDischargeSummary');
// Discharged Patients list
$app->get('/patients/discharged', 'PatientsController@discharged');

// Doctors module
$app->get('/doctors', 'DoctorsController@index');
$app->get('/doctors/add', 'DoctorsController@add');
$app->post('/doctors/store', 'DoctorsController@store');
$app->get('/doctors/view', 'DoctorsController@show'); // expects ?id=123
$app->get('/doctors/schedule', 'DoctorsController@schedule');
$app->post('/doctors/schedule/store', 'DoctorsController@scheduleStore');
$app->post('/doctors/schedule/delete', 'DoctorsController@scheduleDelete');
// Doctors schedule calendar
$app->get('/doctors/schedule/calendar', 'DoctorsController@scheduleCalendar');
// Doctor attendance
$app->get('/doctors/attendance', 'DoctorsController@attendance');
$app->post('/doctors/attendance/store', 'DoctorsController@attendanceStore');
$app->post('/doctors/attendance/delete', 'DoctorsController@attendanceDelete');

// Appointments (OPD) module
$app->get('/appointments', 'AppointmentsController@index');
$app->get('/appointments/add', 'AppointmentsController@add');
$app->post('/appointments/store', 'AppointmentsController@store');
$app->get('/appointments/view', 'AppointmentsController@show'); // expects ?id=123

// OPD Registration (under Patients module)
$app->get('/opd/registration', 'OPDController@registration');
$app->get('/opd', 'OPDController@index');
$app->post('/opd/store', 'OPDController@store');
$app->get('/opd/view', 'OPDController@show');

// Billing module
$app->get('/billing', 'BillingController@index');
$app->get('/billing/add', 'BillingController@add');
$app->post('/billing/store', 'BillingController@store');
$app->get('/billing/view', 'BillingController@show'); // expects ?id=123
$app->post('/billing/add-payment', 'BillingController@addPayment');
// Billing submodules
$app->get('/billing/payments', 'BillingController@payments');
$app->get('/billing/refunds', 'BillingController@refunds');
$app->get('/billing/items', 'BillingController@items');
$app->get('/billing/estimates', 'BillingController@estimates');

// IPD: Beds
$app->get('/beds', 'BedsController@index');
$app->get('/beds/add', 'BedsController@add');
$app->post('/beds/store', 'BedsController@store');

// IPD: Admissions
$app->get('/admissions', 'AdmissionsController@index');
$app->get('/admissions/add', 'AdmissionsController@add');
$app->post('/admissions/store', 'AdmissionsController@store');
$app->get('/admissions/view', 'AdmissionsController@show'); // ?id=123
$app->post('/admissions/discharge', 'AdmissionsController@discharge');

// Pharmacy: Medicines
$app->get('/pharmacy/medicines', 'PharmacyController@medicines');
$app->get('/pharmacy/medicines/add', 'PharmacyController@addMedicine');
$app->post('/pharmacy/medicines/store', 'PharmacyController@storeMedicine');

// Pharmacy: Stock Movements
$app->get('/pharmacy/stock', 'PharmacyController@stock');
$app->post('/pharmacy/stock/in', 'PharmacyController@stockIn');
$app->post('/pharmacy/stock/out', 'PharmacyController@stockOut');

// Pharmacy: Sales
$app->get('/pharmacy/sales', 'PharmacyController@sales');
$app->get('/pharmacy/sales/add', 'PharmacyController@addSale');
$app->post('/pharmacy/sales/store', 'PharmacyController@storeSale');
$app->get('/pharmacy/sales/view', 'PharmacyController@viewSale'); // ?id=123

// Laboratory landing
$app->get('/lab', 'LabController@index');

// HR landing
$app->get('/hr', 'HrController@index');

// Settings landing
$app->get('/settings', 'SettingsController@index');

// Departments (master setup) - use dedicated DepartmentsController CRUD methods
$app->get('/departments', 'DepartmentsController@index');
$app->get('/departments/add', 'DepartmentsController@create');
$app->post('/departments/store', 'DepartmentsController@store');
$app->get('/departments/view', 'DepartmentsController@show');
$app->get('/departments/edit', 'DepartmentsController@edit');
$app->post('/departments/update', 'DepartmentsController@update');
$app->post('/departments/delete', 'DepartmentsController@delete');
$app->post('/departments/deactivate', 'DepartmentsController@deactivate');
$app->post('/departments/restore', 'DepartmentsController@restore');
// Also expose under settings namespace
// (removed alias /settings/departments) - departments available at /departments
$app->get('/departments/checkName', 'DepartmentsController@checkName');

// Services (master setup)
$app->get('/services', 'ServicesController@index');
$app->get('/servicecs', 'ServicesController@index'); // Legacy route support
$app->get('/services/add', 'ServicesController@create');
$app->post('/services/store', 'ServicesController@store');
$app->get('/services/view', 'ServicesController@show');
$app->get('/services/edit', 'ServicesController@edit');
$app->post('/services/update', 'ServicesController@update');
$app->post('/services/delete', 'ServicesController@delete');
$app->post('/services/deactivate', 'ServicesController@deactivate');
$app->post('/services/restore', 'ServicesController@restore');

// Charges (master setup)
$app->get('/charges', 'ChargesController@index');
$app->get('/charges/add', 'ChargesController@create');
$app->post('/charges/store', 'ChargesController@store');
$app->get('/charges/view', 'ChargesController@show');
$app->get('/charges/edit', 'ChargesController@edit');
$app->post('/charges/update', 'ChargesController@update');
$app->post('/charges/delete', 'ChargesController@delete');
$app->post('/charges/deactivate', 'ChargesController@deactivate');
$app->post('/charges/restore', 'ChargesController@restore');

// Rooms/Wards (master setup)
$app->get('/rooms', 'RoomsController@index');
$app->get('/rooms/add', 'RoomsController@create');
$app->post('/rooms/store', 'RoomsController@store');
$app->get('/rooms/view', 'RoomsController@show');
$app->get('/rooms/edit', 'RoomsController@edit');
$app->post('/rooms/update', 'RoomsController@update');
$app->post('/rooms/delete', 'RoomsController@delete');
$app->post('/rooms/deactivate', 'RoomsController@deactivate');
$app->post('/rooms/restore', 'RoomsController@restore');
$app->get('/rooms/add-bed', 'RoomsController@addBed');
$app->post('/rooms/store-bed', 'RoomsController@storeBed');
$app->get('/rooms/edit-bed', 'RoomsController@editBed');
$app->post('/rooms/update-bed', 'RoomsController@updateBed');
$app->post('/rooms/delete-bed', 'RoomsController@deleteBed');

// Staff Management (master setup)
$app->get('/staff', 'StaffController@index');
$app->get('/staff/add', 'StaffController@create');
$app->post('/staff/store', 'StaffController@store');
$app->get('/staff/view', 'StaffController@show');
$app->get('/staff/edit', 'StaffController@edit');
$app->post('/staff/update', 'StaffController@update');
$app->post('/staff/delete', 'StaffController@delete');
$app->post('/staff/deactivate', 'StaffController@deactivate');
$app->post('/staff/restore', 'StaffController@restore');

// Attendance Management
$app->get('/attendance', 'AttendanceController@index');
$app->post('/attendance/mark', 'AttendanceController@mark');
$app->post('/attendance/bulk-mark', 'AttendanceController@bulkMark');
$app->post('/attendance/update', 'AttendanceController@update');

// Medical Records module
$app->get('/medical-records', 'MedicalRecordsController@index');
$app->get('/medical-records/visits', 'MedicalRecordsController@visits');
$app->get('/medical-records/prescriptions', 'MedicalRecordsController@prescriptions');
$app->get('/medical-records/labs', 'MedicalRecordsController@labs');
$app->get('/medical-records/imaging', 'MedicalRecordsController@imaging');
$app->get('/medical-records/allergies', 'MedicalRecordsController@allergies');
$app->get('/medical-records/vitals', 'MedicalRecordsController@vitals');
$app->get('/medical-records/documents', 'MedicalRecordsController@documents');
