<?php
declare(strict_types=1);

class AppointmentsController extends Controller
{
    public function index(): void
    {
        $hospitalId = $this->getHospitalId();
        $model = new Appointment();
        $appointments = $model->all($hospitalId);
        $this->view('appointments/list', [
            'title' => 'Appointments',
            'appointments' => $appointments,
        ]);
    }

    public function add(): void
    {
        $hospitalId = $this->getHospitalId();
        $model = new Appointment();
        $this->view('appointments/add', [
            'title' => 'Add Appointment',
            'patients' => $model->patients($hospitalId),
            'doctors' => $model->doctors($hospitalId),
        ]);
    }

    public function store(): void
    {
        if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
            http_response_code(405);
            echo 'Method Not Allowed';
            return;
        }
        $hospitalId = $this->getHospitalId();
        
        $data = [
            'hospital_id' => $hospitalId,
            'patient_id' => (int)($_POST['patient_id'] ?? 0),
            'doctor_id' => (int)($_POST['doctor_id'] ?? 0),
            'scheduled_at' => trim($_POST['scheduled_at'] ?? ''),
            'status' => trim($_POST['status'] ?? 'Booked'),
            'notes' => trim($_POST['notes'] ?? ''),
        ];
        if ($data['patient_id'] <= 0 || $data['doctor_id'] <= 0 || $data['scheduled_at'] === '') {
            http_response_code(422);
            echo 'Patient, Doctor and Date/Time are required.';
            return;
        }
        $model = new Appointment();
        $id = $model->create($data);
        header('Location: /admin/appointments/view?id=' . urlencode((string)$id));
        exit;
    }

    public function show(): void
    {
        $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
        if ($id <= 0) {
            http_response_code(400);
            echo 'Invalid appointment id';
            return;
        }
        $model = new Appointment();
        $appointment = $model->find($id);
        if (!$appointment) {
            http_response_code(404);
            echo 'Appointment not found';
            return;
        }
        $this->view('appointments/view', [
            'title' => 'Appointment Details',
            'appointment' => $appointment,
        ]);
    }
}
