<?php
declare(strict_types=1);

class AuthController extends Controller
{
    public function login(): void
    {
        if (Auth::check()) {
            header('Location: ' . (defined('BASE_URL') ? BASE_URL : '') . '/');
            exit;
        }
        // Ensure a default admin exists (admin@local / admin123)
        try {
            (new Admin())->ensureDefaultAdmin();
        } catch (Throwable $e) {
            // ignore
        }
        $this->view('auth/login', [
            'title' => 'Admin Login',
            'error' => $_GET['error'] ?? null,
        ]);
    }

    public function doLogin(): void
    {
        if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
            http_response_code(405);
            echo 'Method Not Allowed';
            return;
        }

        $email = trim($_POST['email'] ?? '');
        $password = (string)($_POST['password'] ?? '');

        $adminModel = new Admin();
        $user = $adminModel->findByEmail($email);

        if (!$user || !password_verify($password, (string)($user['password_hash'] ?? ''))) {
            header('Location: ' . (defined('BASE_URL') ? BASE_URL : '') . '/login?error=Invalid%20credentials');
            exit;
        }

        Auth::login($user);
        // Ensure session is saved before redirect
        session_write_close();
        header('Location: ' . (defined('BASE_URL') ? BASE_URL : '') . '/');
        exit;
    }

    public function logout(): void
    {
        Auth::logout();
        session_unset();
        session_destroy();
        header('Location: ' . (defined('BASE_URL') ? BASE_URL : '') . '/login');
        exit;
    }
}
