<?php
declare(strict_types=1);

class DashboardController extends Controller
{
    public function index(): void
    {
        // Get current hospital ID from session
        $hospitalId = $this->getHospitalId();

        // Use Dashboard model for all logic
        $dashboardModel = new Dashboard();

        // Get dashboard data
        $stats = $dashboardModel->getStats($hospitalId);
        $today = $dashboardModel->getTodayMetrics($hospitalId);
        $recentAppointments = $dashboardModel->getRecentAppointments(10, $hospitalId);

        // Get hospital info if hospital admin
        $hospital = null;
        if ($hospitalId) {
            $hospital = $dashboardModel->getHospital($hospitalId);
        }

        $this->view('dashboard/index', [
            'title' => 'Admin Dashboard',
            'stats' => $stats,
            'today' => $today,
            'recentAppointments' => $recentAppointments,
            'hospital' => $hospital,
        ]);
    }
}

