<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Add Department') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= htmlspecialchars(BASE_URL) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base ?? BASE_URL) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-body">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? null;
              $formErrors = $_SESSION['form_errors'] ?? [];
              $old = $_SESSION['old'] ?? [];
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger"><?= htmlspecialchars($formError) ?></div>
            <?php endif; ?>
            <form method="post" action="<?= htmlspecialchars($base) ?>/departments/store">
              <div class="row">
                <div class="col-md-6 mb-3">
                  <label class="form-label">Department Name</label>
                  <input name="name" class="form-control" required value="<?= htmlspecialchars($old['name'] ?? '') ?>" />
                  <?php if (!empty($formErrors['name'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['name']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label">Code</label>
                  <input name="code" class="form-control" value="<?= htmlspecialchars($old['code'] ?? '') ?>" />
                  <?php if (!empty($formErrors['code'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['code']) ?></div><?php endif; ?>
                </div>
              </div>

              <div class="mb-3">
                <label class="form-label">Description</label>
                <textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($old['description'] ?? '') ?></textarea>
              </div>

              <div class="row">
                <div class="col-md-6 mb-3">
                  <label class="form-label">HOD (Doctor)</label>
                  <select name="hod_id" class="form-select">
                    <option value="">-- Select HOD --</option>
                    <?php foreach (($doctors ?? []) as $doc): ?>
                        <option value="<?= (int)($doc['id'] ?? 0) ?>" <?= (isset($old['hod_id']) && (int)$old['hod_id'] === (int)($doc['id'] ?? 0)) ? 'selected' : '' ?>><?= htmlspecialchars(($doc['first_name'] ?? '') . ' ' . ($doc['last_name'] ?? '')) ?></option>
                    <?php endforeach; ?>
                  </select>
                    <?php if (!empty($formErrors['hod_id'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['hod_id']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label">OPD Start</label>
                  <input type="time" name="opd_start" class="form-control" value="<?= htmlspecialchars($old['opd_start'] ?? '') ?>" />
                </div>
                <div class="col-md-3 mb-3">
                  <label class="form-label">OPD End</label>
                  <input type="time" name="opd_end" class="form-control" value="<?= htmlspecialchars($old['opd_end'] ?? '') ?>" />
                </div>
              </div>

              <div class="row">
                <div class="col-md-4 mb-3">
                  <label class="form-label">Phone</label>
                  <input name="phone" class="form-control" value="<?= htmlspecialchars($old['phone'] ?? '') ?>" />
                  <?php if (!empty($formErrors['phone'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['phone']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-4 mb-3">
                  <label class="form-label">Email</label>
                  <input name="email" type="email" class="form-control" value="<?= htmlspecialchars($old['email'] ?? '') ?>" />
                  <?php if (!empty($formErrors['email'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['email']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-4 mb-3">
                  <label class="form-label">Floor</label>
                  <input name="floor" class="form-control" value="<?= htmlspecialchars($old['floor'] ?? '') ?>" />
                  <?php if (!empty($formErrors['floor'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['floor']) ?></div><?php endif; ?>
                </div>
              </div>

              <div class="mb-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                  <option value="1" <?= (!isset($old['status']) || (int)$old['status'] === 1) ? 'selected' : '' ?>>Active</option>
                  <option value="0" <?= (isset($old['status']) && (int)$old['status'] === 0) ? 'selected' : '' ?>>Inactive</option>
                </select>
                <?php if (!empty($formErrors['status'])): ?><div class="invalid-feedback d-block"><?= htmlspecialchars($formErrors['status']) ?></div><?php endif; ?>
              </div>

              <div class="text-end">
                <button class="btn btn-primary" type="submit">Save</button>
                <a class="btn btn-secondary ms-2" href="<?= htmlspecialchars($base) ?>/departments">Cancel</a>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const form = document.querySelector('form');
      const nameInput = document.querySelector('input[name="name"]');
      const nameFeedback = document.querySelector('input[name="name"] + .invalid-feedback');

      form.addEventListener('submit', async function(event) {
        event.preventDefault(); // Prevent form submission

        const name = nameInput.value.trim();
        if (name === '') {
          return; // Already handled by required attribute
        }

        try {
          const response = await fetch('<?= htmlspecialchars($base) ?>/departments/checkName?name=' + encodeURIComponent(name));
          const data = await response.json();

          if (data.exists) {
            nameInput.classList.add('is-invalid');
            if (nameFeedback) {
              nameFeedback.textContent = 'Department name already exists.';
            }
          } else {
            form.submit(); // Submit the form if the name is unique
          }
        } catch (error) {
          console.error('Error checking department name:', error);
          // Optionally display a generic error message to the user
          alert('An error occurred while checking the department name.');
          form.submit(); // Fallback to submitting the form
        }
      });

      nameInput.addEventListener('input', function() {
        nameInput.classList.remove('is-invalid');
        if (nameFeedback) {
          nameFeedback.textContent = '';
        }
      });
    });
  </script>
</body>
</html>
