<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Department Details') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
          <div>
            <h1 class="h4 mb-1"><?= htmlspecialchars($department['name'] ?? 'Department') ?></h1>
            <div class="text-muted">Code: <?= htmlspecialchars($department['code'] ?? '-') ?></div>
          </div>
          <div>
            <a class="btn btn-outline-primary" href="<?= htmlspecialchars($base) ?>/departments/edit?id=<?= urlencode((string)($department['id'] ?? 0)) ?>">Edit</a>
            <?php if (isset($department['status']) && (int)$department['status'] === 1): ?>
              <form method="post" action="<?= htmlspecialchars($base) ?>/departments/deactivate" style="display:inline-block" onsubmit="return confirm('Deactivate this department?');">
                <input type="hidden" name="id" value="<?= (int)($department['id'] ?? 0) ?>">
                <button class="btn btn-warning ms-2">Deactivate</button>
              </form>
            <?php else: ?>
              <form method="post" action="<?= htmlspecialchars($base) ?>/departments/restore" style="display:inline-block" onsubmit="return confirm('Restore this department?');">
                <input type="hidden" name="id" value="<?= (int)($department['id'] ?? 0) ?>">
                <button class="btn btn-success ms-2">Restore</button>
              </form>
            <?php endif; ?>
            <a class="btn btn-secondary ms-2" href="<?= htmlspecialchars($base) ?>/departments">Back</a>
          </div>
        </div>

        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          if (!empty($_SESSION['flash_success'])): ?>
            <div class="alert alert-success"><?= htmlspecialchars($_SESSION['flash_success']) ?></div>
        <?php unset($_SESSION['flash_success']); endif; ?>

        <div class="row">
          <div class="col-md-8">
            <div class="card mb-3">
              <div class="card-body">
                <h5 class="card-title">About</h5>
                <p><?= nl2br(htmlspecialchars($department['description'] ?? '-')) ?></p>
                <dl class="row">
                  <dt class="col-sm-3">HOD</dt>
                  <dd class="col-sm-9"><?= htmlspecialchars($department['hod_name'] ?? '-') ?></dd>

                  <dt class="col-sm-3">OPD Timings</dt>
                  <dd class="col-sm-9"><?= htmlspecialchars(($department['opd_start'] ?? '-') . ' - ' . ($department['opd_end'] ?? '-')) ?></dd>

                  <dt class="col-sm-3">Phone / Email</dt>
                  <dd class="col-sm-9"><?= htmlspecialchars($department['phone'] ?? '-') ?> / <?= htmlspecialchars($department['email'] ?? '-') ?></dd>

                  <dt class="col-sm-3">Floor</dt>
                  <dd class="col-sm-9"><?= htmlspecialchars($department['floor'] ?? '-') ?></dd>
                </dl>
              </div>
            </div>

            <div class="card mb-3">
              <div class="card-body">
                <h5 class="card-title">Doctors in this Department (<?= count($doctors ?? []) ?>)</h5>
                <?php if (!empty($doctors)): ?>
                  <ul>
                    <?php foreach ($doctors as $doc): ?>
                      <li><?= htmlspecialchars(($doc['first_name'] ?? '') . ' ' . ($doc['last_name'] ?? '')) ?> - <?= htmlspecialchars($doc['specialty'] ?? '') ?></li>
                    <?php endforeach; ?>
                  </ul>
                <?php else: ?>
                  <div class="text-muted">No doctors assigned.</div>
                <?php endif; ?>
              </div>
            </div>
          </div>

          <div class="col-md-4">
            <div class="card">
              <div class="card-body">
                <h6 class="card-title">Quick Info</h6>
                <p><strong>Status:</strong> <?= ((isset($department['status']) && (int)$department['status'] === 1) ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>') ?></p>
                <p><strong>Total Doctors:</strong> <?= (int)($department['total_doctors'] ?? 0) ?></p>
                <p><strong>Created:</strong> <?= htmlspecialchars($department['created_at'] ?? '-') ?></p>
              </div>
            </div>
          </div>
        </div>

      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
