<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Departments') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3">
          <div class="w-100 mb-2">
            <h1 class="h4 mb-1"><?= htmlspecialchars($title ?? 'Departments') ?></h1>
            <form class="row g-2" method="get" action="<?= htmlspecialchars($base) ?>/departments">
              <div class="col-auto">
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Search departments..." class="form-control form-control-sm" />
              </div>
              <div class="col-auto">
                <select name="status" class="form-select form-select-sm">
                  <option value="">All</option>
                  <option value="1" <?= (isset($status) && $status === 1) ? 'selected' : '' ?>>Active</option>
                  <option value="0" <?= (isset($status) && $status === 0) ? 'selected' : '' ?>>Inactive</option>
                </select>
              </div>
              <div class="col-auto">
                <button class="btn btn-sm btn-primary" type="submit">Filter</button>
              </div>
            </form>
          </div>
          <div>
            <a href="<?= htmlspecialchars($base) ?>/departments/add" class="btn btn-primary">Add Department</a>
          </div>
        </div>

        <div class="card border-0 shadow-sm">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Code</th>
                    <th>Description</th>
                    <th>HOD</th>
                    <th>Status</th>
                    <th>Total Doctors</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($departments)): ?>
                    <?php foreach ($departments as $d): ?>
                    <tr>
                      <td><?= (int)($d['id'] ?? 0) ?></td>
                      <td><?= htmlspecialchars($d['name'] ?? '') ?></td>
                      <td><?= htmlspecialchars($d['code'] ?? '') ?></td>
                      <td><?= htmlspecialchars((string)($d['description'] ?? '')) ?></td>
                      <td><?= htmlspecialchars($d['hod_name'] ?? '') ?></td>
                      <td><?= ((isset($d['status']) && (int)$d['status'] === 1) ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>') ?></td>
                      <td><?= (int)($d['total_doctors'] ?? 0) ?></td>
                      <td class="text-end">
                        <a href="<?= htmlspecialchars($base) ?>/departments/view?id=<?= urlencode((string)($d['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-secondary">View</a>
                        <a href="<?= htmlspecialchars($base) ?>/departments/edit?id=<?= urlencode((string)($d['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-primary ms-1">Edit</a>
                        <?php if (isset($d['status']) && (int)$d['status'] === 1): ?>
                          <form method="post" action="<?= htmlspecialchars($base) ?>/departments/deactivate" style="display:inline-block" onsubmit="return confirm('Deactivate this department?');">
                            <input type="hidden" name="id" value="<?= (int)($d['id'] ?? 0) ?>">
                            <button type="submit" class="btn btn-sm btn-outline-warning ms-1">Deactivate</button>
                          </form>
                        <?php else: ?>
                          <form method="post" action="<?= htmlspecialchars($base) ?>/departments/restore" style="display:inline-block" onsubmit="return confirm('Restore this department?');">
                            <input type="hidden" name="id" value="<?= (int)($d['id'] ?? 0) ?>">
                            <button type="submit" class="btn btn-sm btn-outline-success ms-1">Restore</button>
                          </form>
                        <?php endif; ?>
                      </td>
                    </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr><td colspan="8" class="text-center text-muted py-4">No departments found.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <?php
          // Pagination
          $total = (int)($total ?? 0);
          $perPage = (int)($perPage ?? 20);
          $page = (int)($page ?? 1);
          $pages = $perPage > 0 ? (int)ceil($total / $perPage) : 1;
        ?>
        <?php if ($pages > 1): ?>
          <nav class="mt-3" aria-label="Departments pagination">
            <ul class="pagination pagination-sm">
              <?php for ($p = 1; $p <= $pages; $p++): ?>
                <li class="page-item <?= $p === $page ? 'active' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/departments?page=<?= $p ?>&q=<?= urlencode((string)($q ?? '')) ?>&status=<?= urlencode((string)($status ?? '')) ?>"><?= $p ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
