<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'IPD Admission') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
  <style>
    .form-section {
      background: #f8f9fa;
      border-radius: 8px;
      padding: 1.5rem;
      margin-bottom: 1.5rem;
      border-left: 4px solid #0d6efd;
    }
    .section-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: #495057;
      margin-bottom: 1rem;
      padding-bottom: 0.5rem;
      border-bottom: 2px solid #dee2e6;
    }
    .patient-info-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 8px;
      padding: 1rem;
    }
  </style>
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-primary text-white">
            <div class="d-flex justify-content-between align-items-center">
              <h2 class="h5 mb-0"><i class="fas fa-procedures me-2"></i>IPD Admission</h2>
              <a href="<?= htmlspecialchars($base) ?>/admissions" class="btn btn-light btn-sm">
                <i class="fas fa-list me-1"></i>View All Admissions
              </a>
            </div>
          </div>
          <div class="card-body p-4">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? $formError ?? null;
              $formErrors = $_SESSION['form_errors'] ?? $formErrors ?? [];
              $old = $_SESSION['old'] ?? $old ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>
            <?php endif; ?>

            <!-- Patient Information (if pre-selected) -->
            <?php if (!empty($selectedPatient)): ?>
              <div class="patient-info-card mb-4">
                <div class="d-flex justify-content-between align-items-center">
                  <div>
                    <h5 class="mb-1"><i class="fas fa-user me-2"></i><?= htmlspecialchars(($selectedPatient['first_name'] ?? '') . ' ' . ($selectedPatient['last_name'] ?? '')) ?></h5>
                    <div class="small">
                      <span class="me-3"><i class="fas fa-phone me-1"></i><?= htmlspecialchars($selectedPatient['phone'] ?? 'N/A') ?></span>
                      <span><i class="fas fa-venus-mars me-1"></i><?= htmlspecialchars($selectedPatient['gender'] ?? 'N/A') ?></span>
                    </div>
                  </div>
                  <a href="<?= htmlspecialchars($base) ?>/patients/add" class="btn btn-light btn-sm">
                    <i class="fas fa-plus me-1"></i>New Patient
                  </a>
                </div>
              </div>
            <?php endif; ?>
            
            <form method="post" action="<?= htmlspecialchars($base) ?>/admissions/store" id="admissionForm">
              <!-- Patient Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-user-injured me-2"></i>Patient Information</div>
                <div class="row">
                  <div class="col-md-8 mb-3">
                    <label class="form-label fw-semibold">Select Patient <span class="text-danger">*</span></label>
                    <select name="patient_id" id="patient_id" class="form-select form-select-lg" required>
                      <option value="">-- Search or Select Patient --</option>
                      <?php foreach (($patients ?? []) as $p): ?>
                        <option value="<?= (int)$p['id'] ?>" 
                          <?= ((isset($old['patient_id']) && (int)$old['patient_id'] === (int)$p['id']) || (isset($selectedPatient['id']) && (int)$selectedPatient['id'] === (int)$p['id'])) ? 'selected' : '' ?>>
                          <?= htmlspecialchars($p['first_name'] . ' ' . $p['last_name'] . ' (ID: P' . str_pad((string)$p['id'], 3, '0', STR_PAD_LEFT) . ', Phone: ' . ($p['phone'] ?? 'N/A') . ')') ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                    <?php if (!empty($formErrors['patient_id'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['patient_id']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-4 mb-3 d-flex align-items-end">
                    <a href="<?= htmlspecialchars($base) ?>/patients/add" class="btn btn-outline-primary btn-lg w-100">
                      <i class="fas fa-plus-circle me-2"></i>Register New Patient
                    </a>
                  </div>
                </div>
                <?php if (!empty($selectedPatient)): ?>
                  <div class="row mt-3">
                    <div class="col-md-4">
                      <p class="mb-0 text-muted">Name: <strong><?= htmlspecialchars($selectedPatient['first_name'] . ' ' . $selectedPatient['last_name']) ?></strong></p>
                    </div>
                    <div class="col-md-4">
                      <p class="mb-0 text-muted">Gender: <strong><?= htmlspecialchars($selectedPatient['gender'] ?? 'N/A') ?></strong></p>
                    </div>
                    <div class="col-md-4">
                      <p class="mb-0 text-muted">Phone: <strong><?= htmlspecialchars($selectedPatient['phone'] ?? 'N/A') ?></strong></p>
                    </div>
                  </div>
                <?php endif; ?>
              </div>

              <!-- Admission Details -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-hospital me-2"></i>Admission Details</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Department <span class="text-danger">*</span></label>
                    <select name="department_id" id="department_id" class="form-select form-select-lg" required>
                      <option value="">-- Select Department --</option>
                      <?php foreach (($departments ?? []) as $dept): ?>
                        <option value="<?= (int)$dept['id'] ?>" <?= (isset($old['department_id']) && (int)$old['department_id'] === (int)$dept['id']) ? 'selected' : '' ?>>
                          <?= htmlspecialchars($dept['name']) ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                    <?php if (!empty($formErrors['department_id'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['department_id']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Consulting Doctor</label>
                    <select name="doctor_id" id="doctor_id" class="form-select form-select-lg">
                      <option value="">-- Select Doctor (Optional) --</option>
                      <?php foreach (($doctors ?? []) as $doc): ?>
                        <option value="<?= (int)$doc['id'] ?>" 
                          data-department-id="<?= (int)($doc['department_id'] ?? 0) ?>"
                          <?= (isset($old['doctor_id']) && (int)$old['doctor_id'] === (int)$doc['id']) ? 'selected' : '' ?>>
                          <?= htmlspecialchars($doc['first_name'] . ' ' . $doc['last_name'] . ' (' . ($doc['specialty'] ?? 'N/A') . ')') ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                    <?php if (!empty($formErrors['doctor_id'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['doctor_id']) ?></div><?php endif; ?>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Admission Type</label>
                    <select name="admission_type" class="form-select form-select-lg">
                      <option value="Emergency" <?= (!isset($old['admission_type']) || $old['admission_type'] === 'Emergency') ? 'selected' : '' ?>>Emergency</option>
                      <option value="Routine" <?= (isset($old['admission_type']) && $old['admission_type'] === 'Routine') ? 'selected' : '' ?>>Routine</option>
                      <option value="Scheduled" <?= (isset($old['admission_type']) && $old['admission_type'] === 'Scheduled') ? 'selected' : '' ?>>Scheduled</option>
                    </select>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Bed/Ward Assignment</label>
                    <select name="bed_id" id="bed_id" class="form-select form-select-lg">
                      <option value="">-- Select Bed (Optional) --</option>
                      <?php foreach (($beds ?? []) as $bed): ?>
                        <option value="<?= (int)$bed['id'] ?>" <?= (isset($old['bed_id']) && (int)$old['bed_id'] === (int)$bed['id']) ? 'selected' : '' ?>>
                          <?= htmlspecialchars($bed['ward'] . ' - ' . $bed['number'] . ' (' . ($bed['type'] ?? 'Standard') . ')') ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                    <?php if (!empty($formErrors['bed_id'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['bed_id']) ?></div><?php endif; ?>
                  </div>
                </div>

                <div class="mb-3">
                  <label class="form-label fw-semibold">Initial Diagnosis</label>
                  <input type="text" name="diagnosis" value="<?= htmlspecialchars($old['diagnosis'] ?? '') ?>" class="form-control form-control-lg" placeholder="Enter initial diagnosis" />
                  <?php if (!empty($formErrors['diagnosis'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['diagnosis']) ?></div><?php endif; ?>
                </div>

                <div class="mb-3">
                  <label class="form-label fw-semibold">Admission Notes</label>
                  <textarea name="notes" class="form-control" rows="3" placeholder="Enter any additional notes or remarks"><?= htmlspecialchars($old['notes'] ?? '') ?></textarea>
                </div>
              </div>

              <div class="d-flex justify-content-end gap-2 mt-4">
                <a class="btn btn-secondary btn-lg" href="<?= htmlspecialchars($base) ?>/admissions">
                  <i class="fas fa-times me-2"></i>Cancel
                </a>
                <button class="btn btn-primary btn-lg" type="submit">
                  <i class="fas fa-save me-2"></i>Admit Patient
                </button>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const departmentSelect = document.getElementById('department_id');
      const doctorSelect = document.getElementById('doctor_id');
      const allDoctors = Array.from(doctorSelect.options).filter(option => option.value !== '');

      // Function to filter doctors based on selected department
      function filterDoctors() {
        const selectedDepartmentId = departmentSelect.value;
        doctorSelect.innerHTML = '<option value="">-- Select Doctor (Optional) --</option>';

        allDoctors.forEach(doctorOption => {
          const doctorDepartmentId = doctorOption.dataset.departmentId;
          if (selectedDepartmentId === '' || doctorDepartmentId === selectedDepartmentId) {
            doctorSelect.appendChild(doctorOption.cloneNode(true));
          }
        });

        // Re-select old doctor if it's still valid
        const oldDoctorId = "<?= htmlspecialchars($old['doctor_id'] ?? '') ?>";
        if (oldDoctorId && doctorSelect.querySelector(`option[value="${oldDoctorId}"]`)) {
          doctorSelect.value = oldDoctorId;
        } else {
          doctorSelect.value = '';
        }
      }

      departmentSelect.addEventListener('change', filterDoctors);

      // Initial filter on page load if a department was previously selected
      if (departmentSelect.value) {
        filterDoctors();
      }

      // If a patient was pre-selected via GET parameter, ensure it's shown
      const initialPatientId = "<?= htmlspecialchars($selectedPatient['id'] ?? '') ?>";
      if (initialPatientId) {
        document.getElementById('patient_id').value = initialPatientId;
      }
    });
  </script>
</body>
</html>
