<?php declare(strict_types=1);
// Page-specific styles
$pageStyles = '
    .filter-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 12px;
    }
    .status-badge-active {
      background-color: #198754;
      color: white;
    }
    .status-badge-discharged {
      background-color: #6c757d;
      color: white;
    }
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? $flashSuccess ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Header Section -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-procedures text-primary me-2"></i>IPD Admissions</h1>
            <p class="text-muted mb-0">Manage inpatient department admissions and bed allocations</p>
          </div>
          <div class="mt-3 mt-md-0">
            <a href="<?= htmlspecialchars($base) ?>/admissions/add" class="btn btn-primary btn-lg shadow-sm">
              <i class="fas fa-plus-circle me-2"></i>New IPD Admission
            </a>
          </div>
        </div>

        <!-- Filter Card -->
        <div class="card filter-card shadow-sm mb-4 border-0">
          <div class="card-body p-4">
            <form method="get" action="<?= htmlspecialchars($base) ?>/admissions" class="row g-3">
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-search me-2"></i>Search</label>
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Patient name, phone..." class="form-control form-control-lg" />
              </div>
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-user-md me-2"></i>Doctor</label>
                <select name="doctor" class="form-select form-select-lg">
                  <option value="">All Doctors</option>
                  <?php foreach (($doctors ?? []) as $doc): ?>
                    <option value="<?= (int)$doc['id'] ?>" <?= (isset($doctor) && (int)$doctor === (int)$doc['id']) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($doc['first_name'] . ' ' . $doc['last_name']) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-filter me-2"></i>Status</label>
                <select name="status" class="form-select form-select-lg">
                  <option value="">All Status</option>
                  <option value="Active" <?= (isset($status) && $status === 'Active') ? 'selected' : '' ?>>Active</option>
                  <option value="Discharged" <?= (isset($status) && $status === 'Discharged') ? 'selected' : '' ?>>Discharged</option>
                </select>
              </div>
              <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-light btn-lg w-100 shadow-sm" type="submit">
                  <i class="fas fa-filter me-2"></i>Filter
                </button>
              </div>
              <div class="col-md-2 d-flex align-items-end">
                <a href="<?= htmlspecialchars($base) ?>/admissions" class="btn btn-outline-light btn-lg w-100 shadow-sm">
                  <i class="fas fa-redo me-2"></i>Reset
                </a>
              </div>
            </form>
          </div>
        </div>

        <!-- Admissions List Table -->
        <div class="card shadow-sm border-0">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th scope="col">Admission ID</th>
                    <th scope="col">Patient Name</th>
                    <th scope="col">Doctor</th>
                    <th scope="col">Department</th>
                    <th scope="col">Bed/Ward</th>
                    <th scope="col">Admitted On</th>
                    <th scope="col">Discharged On</th>
                    <th scope="col">Status</th>
                    <th scope="col">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($admissions)): ?>
                    <?php foreach ($admissions as $adm): ?>
                      <tr>
                        <td><strong>IPD<?= str_pad((string)$adm['id'], 4, '0', STR_PAD_LEFT) ?></strong></td>
                        <td>
                          <div class="fw-semibold"><?= htmlspecialchars($adm['p_first'] . ' ' . $adm['p_last']) ?></div>
                          <small class="text-muted"><?= htmlspecialchars($adm['patient_phone'] ?? 'N/A') ?></small>
                        </td>
                        <td>
                          <?php if (!empty($adm['d_first'])): ?>
                            <?= htmlspecialchars($adm['d_first'] . ' ' . $adm['d_last']) ?>
                            <?php if (!empty($adm['doctor_specialty'])): ?>
                              <br><small class="text-muted"><?= htmlspecialchars($adm['doctor_specialty']) ?></small>
                            <?php endif; ?>
                          <?php else: ?>
                            <span class="text-muted">Not Assigned</span>
                          <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($adm['department_name'] ?? 'N/A') ?></td>
                        <td>
                          <?php if (!empty($adm['ward'])): ?>
                            <span class="badge bg-info"><?= htmlspecialchars($adm['ward']) ?></span>
                            <?php if (!empty($adm['bed_number'])): ?>
                              <br><small class="text-muted">Bed: <?= htmlspecialchars($adm['bed_number']) ?></small>
                            <?php endif; ?>
                          <?php else: ?>
                            <span class="text-muted">Not Assigned</span>
                          <?php endif; ?>
                        </td>
                        <td><?= date('d-M-Y h:i A', strtotime($adm['admitted_at'])) ?></td>
                        <td>
                          <?php if (!empty($adm['discharged_at'])): ?>
                            <?= date('d-M-Y h:i A', strtotime($adm['discharged_at'])) ?>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if (empty($adm['discharged_at'])): ?>
                            <span class="badge status-badge-active">Active</span>
                          <?php else: ?>
                            <span class="badge status-badge-discharged">Discharged</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <a href="<?= htmlspecialchars($base) ?>/admissions/view?id=<?= urlencode((string)$adm['id']) ?>" class="btn btn-sm btn-outline-info me-1" title="View Details">
                            <i class="fas fa-eye"></i>
                          </a>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="9" class="text-center text-muted py-4">No IPD admissions found.</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <!-- Pagination -->
        <?php if (($total ?? 0) > ($perPage ?? 20)): ?>
          <nav aria-label="Page navigation" class="mt-4">
            <ul class="pagination justify-content-center">
              <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                <a class="page-link" href="<?= htmlspecialchars($base) ?>/admissions?<?= http_build_query(array_merge($_GET, ['page' => $page - 1])) ?>" aria-label="Previous">
                  <span aria-hidden="true">&laquo;</span>
                </a>
              </li>
              <?php for ($i = 1; $i <= ceil($total / $perPage); $i++): ?>
                <li class="page-item <?= ($page === $i) ? 'active' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/admissions?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>"><?= $i ?></a>
                </li>
              <?php endfor; ?>
              <li class="page-item <?= ($page >= ceil($total / $perPage)) ? 'disabled' : '' ?>">
                <a class="page-link" href="<?= htmlspecialchars($base) ?>/admissions?<?= http_build_query(array_merge($_GET, ['page' => $page + 1])) ?>" aria-label="Next">
                  <span aria-hidden="true">&raquo;</span>
                </a>
              </li>
            </ul>
          </nav>
        <?php endif; ?>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>
