<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'IPD Admission Details') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
  <style>
    .info-card {
      border-left: 4px solid #0d6efd;
      transition: transform 0.2s;
    }
    .info-card:hover {
      transform: translateX(5px);
    }
    .status-badge-active {
      background-color: #198754;
      color: white;
    }
    .status-badge-discharged {
      background-color: #6c757d;
      color: white;
    }
  </style>
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-procedures text-primary me-2"></i>IPD Admission Details</h1>
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= htmlspecialchars($base) ?>/admissions">IPD Admissions</a></li>
                <li class="breadcrumb-item active">Details</li>
              </ol>
            </nav>
          </div>
          <div>
            <a class="btn btn-secondary ms-2" href="<?= htmlspecialchars($base) ?>/admissions">
              <i class="fas fa-arrow-left me-2"></i>Back to List
            </a>
          </div>
        </div>

        <?php if (!empty($admission)): ?>
          <div class="row g-4">
            <!-- Admission Information -->
            <div class="col-md-6">
              <div class="card info-card shadow-sm border-0">
                <div class="card-header bg-light">
                  <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Admission Information</h5>
                </div>
                <div class="card-body">
                  <table class="table table-borderless mb-0">
                    <tr>
                      <th width="40%">Admission ID</th>
                      <td><strong class="text-primary">IPD<?= str_pad((string)($admission['id'] ?? 0), 4, '0', STR_PAD_LEFT) ?></strong></td>
                    </tr>
                    <tr>
                      <th>Admitted At</th>
                      <td><?= date('d-M-Y h:i A', strtotime($admission['admitted_at'] ?? '')) ?></td>
                    </tr>
                    <tr>
                      <th>Discharged At</th>
                      <td>
                        <?php if (!empty($admission['discharged_at'])): ?>
                          <?= date('d-M-Y h:i A', strtotime($admission['discharged_at'])) ?>
                        <?php else: ?>
                          <span class="text-muted">Not Discharged</span>
                        <?php endif; ?>
                      </td>
                    </tr>
                    <tr>
                      <th>Status</th>
                      <td>
                        <?php if (empty($admission['discharged_at'])): ?>
                          <span class="badge status-badge-active">Active</span>
                        <?php else: ?>
                          <span class="badge status-badge-discharged">Discharged</span>
                        <?php endif; ?>
                      </td>
                    </tr>
                    <tr>
                      <th>Duration</th>
                      <td>
                        <?php
                          $admitted = strtotime($admission['admitted_at'] ?? '');
                          $discharged = !empty($admission['discharged_at']) ? strtotime($admission['discharged_at']) : time();
                          $diff = $discharged - $admitted;
                          $days = floor($diff / (60 * 60 * 24));
                          $hours = floor(($diff % (60 * 60 * 24)) / (60 * 60));
                          echo $days . ' days, ' . $hours . ' hours';
                        ?>
                      </td>
                    </tr>
                  </table>
                </div>
              </div>
            </div>

            <!-- Patient Information -->
            <div class="col-md-6">
              <div class="card info-card shadow-sm border-0" style="border-left-color: #198754;">
                <div class="card-header bg-light">
                  <h5 class="mb-0"><i class="fas fa-user-injured me-2"></i>Patient Information</h5>
                </div>
                <div class="card-body">
                  <table class="table table-borderless mb-0">
                    <tr>
                      <th width="40%">Patient Name</th>
                      <td>
                        <a href="<?= htmlspecialchars($base) ?>/patients/view?id=<?= urlencode((string)($admission['patient_id'] ?? 0)) ?>">
                          <strong><?= htmlspecialchars(($admission['p_first'] ?? '') . ' ' . ($admission['p_last'] ?? '')) ?></strong>
                        </a>
                      </td>
                    </tr>
                    <tr>
                      <th>Gender</th>
                      <td><?= htmlspecialchars($admission['patient_gender'] ?? 'N/A') ?></td>
                    </tr>
                    <tr>
                      <th>Phone</th>
                      <td><?= htmlspecialchars($admission['patient_phone'] ?? 'N/A') ?></td>
                    </tr>
                    <tr>
                      <th>Email</th>
                      <td><?= htmlspecialchars($admission['patient_email'] ?? 'N/A') ?></td>
                    </tr>
                    <?php if (!empty($admission['patient_dob'])): ?>
                      <tr>
                        <th>Date of Birth</th>
                        <td><?= date('d-M-Y', strtotime($admission['patient_dob'])) ?></td>
                      </tr>
                    <?php endif; ?>
                    <?php if (!empty($admission['patient_address'])): ?>
                      <tr>
                        <th>Address</th>
                        <td><?= htmlspecialchars($admission['patient_address']) ?></td>
                      </tr>
                    <?php endif; ?>
                  </table>
                </div>
              </div>
            </div>

            <!-- Doctor Information -->
            <?php if (!empty($admission['doctor_id'])): ?>
              <div class="col-md-6">
                <div class="card info-card shadow-sm border-0" style="border-left-color: #ffc107;">
                  <div class="card-header bg-light">
                    <h5 class="mb-0"><i class="fas fa-user-md me-2"></i>Consulting Doctor</h5>
                  </div>
                  <div class="card-body">
                    <table class="table table-borderless mb-0">
                      <tr>
                        <th width="40%">Doctor Name</th>
                        <td>
                          <a href="<?= htmlspecialchars($base) ?>/doctors/view?id=<?= urlencode((string)($admission['doctor_id'] ?? 0)) ?>">
                            <strong><?= htmlspecialchars(($admission['d_first'] ?? '') . ' ' . ($admission['d_last'] ?? '')) ?></strong>
                          </a>
                        </td>
                      </tr>
                      <tr>
                        <th>Specialty</th>
                        <td><?= htmlspecialchars($admission['doctor_specialty'] ?? 'N/A') ?></td>
                      </tr>
                      <tr>
                        <th>Department</th>
                        <td><?= htmlspecialchars($admission['department_name'] ?? 'N/A') ?></td>
                      </tr>
                      <?php if (!empty($admission['doctor_phone'])): ?>
                        <tr>
                          <th>Phone</th>
                          <td><?= htmlspecialchars($admission['doctor_phone']) ?></td>
                        </tr>
                      <?php endif; ?>
                    </table>
                  </div>
                </div>
              </div>
            <?php endif; ?>

            <!-- Bed/Ward Information -->
            <?php if (!empty($admission['ward'])): ?>
              <div class="col-md-6">
                <div class="card info-card shadow-sm border-0" style="border-left-color: #17a2b8;">
                  <div class="card-header bg-light">
                    <h5 class="mb-0"><i class="fas fa-bed me-2"></i>Bed/Ward Assignment</h5>
                  </div>
                  <div class="card-body">
                    <table class="table table-borderless mb-0">
                      <tr>
                        <th width="40%">Ward</th>
                        <td><strong><?= htmlspecialchars($admission['ward']) ?></strong></td>
                      </tr>
                      <?php if (!empty($admission['bed_number'])): ?>
                        <tr>
                          <th>Bed Number</th>
                          <td><?= htmlspecialchars($admission['bed_number']) ?></td>
                        </tr>
                      <?php endif; ?>
                      <?php if (!empty($admission['bed_type'])): ?>
                        <tr>
                          <th>Bed Type</th>
                          <td><?= htmlspecialchars($admission['bed_type']) ?></td>
                        </tr>
                      <?php endif; ?>
                    </table>
                  </div>
                </div>
              </div>
            <?php endif; ?>

            <!-- Diagnosis & Notes -->
            <div class="col-md-12">
              <div class="card info-card shadow-sm border-0" style="border-left-color: #6c757d;">
                <div class="card-header bg-light">
                  <h5 class="mb-0"><i class="fas fa-sticky-note me-2"></i>Diagnosis & Notes</h5>
                </div>
                <div class="card-body">
                  <?php if (!empty($admission['diagnosis'])): ?>
                    <div class="mb-3">
                      <strong>Initial Diagnosis:</strong>
                      <p class="mb-0 mt-2"><?= htmlspecialchars($admission['diagnosis']) ?></p>
                    </div>
                  <?php endif; ?>
                  <?php if (!empty($admission['notes'])): ?>
                    <div>
                      <strong>Notes:</strong>
                      <p class="mb-0 mt-2"><?= nl2br(htmlspecialchars($admission['notes'])) ?></p>
                    </div>
                  <?php endif; ?>
                  <?php if (empty($admission['diagnosis']) && empty($admission['notes'])): ?>
                    <p class="text-muted mb-0">No diagnosis or notes available.</p>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>

          <!-- Discharge Button (if not discharged) -->
          <?php if (empty($admission['discharged_at'])): ?>
            <div class="card shadow-sm border-0 mt-4">
              <div class="card-body">
                <form method="post" action="<?= htmlspecialchars($base) ?>/admissions/discharge" onsubmit="return confirm('Are you sure you want to discharge this patient?');">
                  <input type="hidden" name="id" value="<?= (int)($admission['id'] ?? 0) ?>" />
                  <button type="submit" class="btn btn-danger btn-lg">
                    <i class="fas fa-sign-out-alt me-2"></i>Discharge Patient
                  </button>
                </form>
              </div>
            </div>
          <?php endif; ?>
        <?php else: ?>
          <div class="alert alert-warning text-center" role="alert">
            <i class="fas fa-exclamation-triangle me-2"></i>IPD admission details not found.
          </div>
        <?php endif; ?>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
