<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Add Appointment') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="row justify-content-center">
          <div class="col-12 col-lg-8">
            <div class="card border-0 shadow-sm">
              <div class="card-body p-4">
                <h1 class="h4 mb-4">Add Appointment</h1>
                <form method="post" action="<?= htmlspecialchars($base) ?>/appointments/store" novalidate>
                  <div class="row g-3">
                    <div class="col-md-6">
                      <label class="form-label">Patient *</label>
                      <select name="patient_id" class="form-select" required>
                        <option value="">Select patient</option>
                        <?php foreach (($patients ?? []) as $p): ?>
                          <option value="<?= (int)$p['id'] ?>"><?= htmlspecialchars(($p['first_name'] ?? '').' '.($p['last_name'] ?? '')) ?></option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="form-label">Doctor *</label>
                      <select name="doctor_id" class="form-select" required>
                        <option value="">Select doctor</option>
                        <?php foreach (($doctors ?? []) as $d): ?>
                          <option value="<?= (int)$d['id'] ?>"><?= htmlspecialchars(($d['first_name'] ?? '').' '.($d['last_name'] ?? '')) ?></option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="form-label">Date & Time *</label>
                      <input type="datetime-local" name="scheduled_at" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                      <label class="form-label">Status</label>
                      <select name="status" class="form-select">
                        <option>Booked</option>
                        <option>Completed</option>
                        <option>Cancelled</option>
                        <option>NoShow</option>
                      </select>
                    </div>
                    <div class="col-12">
                      <label class="form-label">Notes</label>
                      <textarea name="notes" class="form-control" rows="3"></textarea>
                    </div>
                  </div>
                  <div class="mt-4 d-flex gap-2">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <a href="<?= htmlspecialchars($base) ?>/appointments" class="btn btn-outline-secondary">Cancel</a>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
