<?php declare(strict_types=1);
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
          <h1 class="h4 mb-0">Appointments</h1>
          <a href="<?= htmlspecialchars($base) ?>/appointments/add" class="btn btn-primary">Add Appointment</a>
        </div>
        <div class="card border-0 shadow-sm">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>ID</th>
                    <th>Scheduled At</th>
                    <th>Patient</th>
                    <th>Doctor</th>
                    <th>Status</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                <?php if (!empty($appointments)): ?>
                  <?php foreach ($appointments as $a): ?>
                  <tr>
                    <td><?= (int)$a['id'] ?></td>
                    <td><?= htmlspecialchars($a['scheduled_at'] ?? '') ?></td>
                    <td><?= htmlspecialchars(($a['p_first'] ?? '').' '.($a['p_last'] ?? '')) ?></td>
                    <td><?= htmlspecialchars(($a['d_first'] ?? '').' '.($a['d_last'] ?? '')) ?></td>
                    <td><span class="badge bg-secondary"><?= htmlspecialchars($a['status'] ?? '') ?></span></td>
                    <td><a class="btn btn-sm btn-outline-primary" href="<?= htmlspecialchars($base) ?>/appointments/view?id=<?= urlencode((string)$a['id']) ?>">View</a></td>
                  </tr>
                  <?php endforeach; ?>
                <?php else: ?>
                  <tr><td colspan="6" class="text-center text-muted py-4">No appointments found.</td></tr>
                <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>
