<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Appointment Details') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <a href="<?= htmlspecialchars($base) ?>/appointments" class="btn btn-link">&larr; Back to Appointments</a>
        <div class="row justify-content-center mt-2">
          <div class="col-12 col-lg-8">
            <div class="card border-0 shadow-sm">
              <div class="card-body p-4">
                <h1 class="h4 mb-4">Appointment Details</h1>
                <div class="row g-3">
                  <div class="col-md-6">
                    <div class="text-secondary">Scheduled At</div>
                    <div class="fw-semibold"><?= htmlspecialchars($appointment['scheduled_at'] ?? '') ?></div>
                  </div>
                  <div class="col-md-6">
                    <div class="text-secondary">Status</div>
                    <div class="fw-semibold"><span class="badge bg-secondary"><?= htmlspecialchars($appointment['status'] ?? '') ?></span></div>
                  </div>
                  <div class="col-md-6">
                    <div class="text-secondary">Patient</div>
                    <div class="fw-semibold"><?= htmlspecialchars(($appointment['p_first'] ?? '').' '.($appointment['p_last'] ?? '')) ?></div>
                  </div>
                  <div class="col-md-6">
                    <div class="text-secondary">Doctor</div>
                    <div class="fw-semibold"><?= htmlspecialchars(($appointment['d_first'] ?? '').' '.($appointment['d_last'] ?? '')) ?></div>
                  </div>
                  <div class="col-12">
                    <div class="text-secondary">Notes</div>
                    <div class="fw-semibold"><?= nl2br(htmlspecialchars($appointment['notes'] ?? '')) ?></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
