<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Attendance Management') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-calendar-check text-primary me-2"></i>Attendance Management</h1>
            <p class="text-muted mb-0">Mark and manage staff attendance</p>
          </div>
          <div class="mt-3 mt-md-0">
            <a href="<?= htmlspecialchars($base) ?>/staff" class="btn btn-secondary btn-lg shadow-sm">
              <i class="fas fa-users me-2"></i>Staff Management
            </a>
          </div>
        </div>

        <!-- Date Filter -->
        <div class="card shadow-sm mb-4 border-0">
          <div class="card-body">
            <form method="get" action="<?= htmlspecialchars($base) ?>/attendance" class="row g-3">
              <div class="col-md-4">
                <label class="form-label fw-semibold">Select Date</label>
                <input type="date" name="date" value="<?= htmlspecialchars($date ?? date('Y-m-d')) ?>" class="form-control form-control-lg" />
              </div>
              <div class="col-md-4">
                <label class="form-label fw-semibold">Department</label>
                <select name="department_id" class="form-select form-select-lg">
                  <option value="">All Departments</option>
                  <?php foreach (($departments ?? []) as $dept): ?>
                    <option value="<?= (int)$dept['id'] ?>" <?= (isset($department_id) && (int)$department_id === (int)$dept['id']) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($dept['name']) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-4 d-flex align-items-end">
                <button class="btn btn-primary btn-lg w-100" type="submit">
                  <i class="fas fa-filter me-2"></i>Filter
                </button>
              </div>
            </form>
          </div>
        </div>

        <!-- Attendance Form -->
        <div class="card shadow-sm border-0 mb-4">
          <div class="card-header bg-success text-white">
            <h5 class="mb-0"><i class="fas fa-calendar-plus me-2"></i>Mark Attendance for <?= date('d-m-Y', strtotime($date ?? date('Y-m-d'))) ?></h5>
          </div>
          <div class="card-body">
            <form method="post" action="<?= htmlspecialchars($base) ?>/attendance/bulk-mark">
              <input type="hidden" name="date" value="<?= htmlspecialchars($date ?? date('Y-m-d')) ?>">
              <div class="table-responsive">
                <table class="table table-hover">
                  <thead class="table-light">
                    <tr>
                      <th>Employee ID</th>
                      <th>Name</th>
                      <th>Department</th>
                      <th>Check In</th>
                      <th>Check Out</th>
                      <th>Status</th>
                      <th>Remarks</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php 
                    $attendanceMap = [];
                    foreach (($attendance ?? []) as $att) {
                      $attendanceMap[$att['staff_id']] = $att;
                    }
                    foreach (($staff ?? []) as $s): 
                      $att = $attendanceMap[$s['id'] ?? 0] ?? null;
                    ?>
                      <tr>
                        <td><strong><?= htmlspecialchars($s['employee_id'] ?? '') ?></strong></td>
                        <td><?= htmlspecialchars(($s['first_name'] ?? '') . ' ' . ($s['last_name'] ?? '')) ?></td>
                        <td><?= htmlspecialchars($s['department_name'] ?? 'N/A') ?></td>
                        <td>
                          <input type="time" name="attendance[<?= (int)($s['id'] ?? 0) ?>][check_in]" 
                                 value="<?= !empty($att['check_in']) ? date('H:i', strtotime($att['check_in'])) : '' ?>" 
                                 class="form-control form-control-sm" />
                        </td>
                        <td>
                          <input type="time" name="attendance[<?= (int)($s['id'] ?? 0) ?>][check_out]" 
                                 value="<?= !empty($att['check_out']) ? date('H:i', strtotime($att['check_out'])) : '' ?>" 
                                 class="form-control form-control-sm" />
                        </td>
                        <td>
                          <select name="attendance[<?= (int)($s['id'] ?? 0) ?>][status]" class="form-select form-select-sm">
                            <option value="Present" <?= (!empty($att) && $att['status'] === 'Present') ? 'selected' : '' ?>>Present</option>
                            <option value="Absent" <?= (!empty($att) && $att['status'] === 'Absent') ? 'selected' : '' ?>>Absent</option>
                            <option value="Half Day" <?= (!empty($att) && $att['status'] === 'Half Day') ? 'selected' : '' ?>>Half Day</option>
                            <option value="Leave" <?= (!empty($att) && $att['status'] === 'Leave') ? 'selected' : '' ?>>Leave</option>
                            <option value="Holiday" <?= (!empty($att) && $att['status'] === 'Holiday') ? 'selected' : '' ?>>Holiday</option>
                          </select>
                        </td>
                        <td>
                          <input type="text" name="attendance[<?= (int)($s['id'] ?? 0) ?>][remarks]" 
                                 value="<?= htmlspecialchars($att['remarks'] ?? '') ?>" 
                                 class="form-control form-control-sm" placeholder="Remarks" />
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
              <div class="mt-3">
                <button type="submit" class="btn btn-success btn-lg">
                  <i class="fas fa-save me-2"></i>Save Attendance
                </button>
              </div>
            </form>
          </div>
        </div>

        <!-- Monthly Report -->
        <?php if (!empty($monthlyReport)): ?>
          <div class="card shadow-sm border-0">
            <div class="card-header bg-info text-white">
              <h5 class="mb-0"><i class="fas fa-chart-bar me-2"></i>Monthly Report - <?= date('F Y', strtotime($month . '-01')) ?></h5>
            </div>
            <div class="card-body p-0">
              <div class="table-responsive">
                <table class="table table-hover mb-0">
                  <thead class="table-light">
                    <tr>
                      <th>Employee ID</th>
                      <th>Name</th>
                      <th>Department</th>
                      <th>Present</th>
                      <th>Absent</th>
                      <th>Half Day</th>
                      <th>Leave</th>
                      <th>Total Days</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($monthlyReport as $report): ?>
                      <tr>
                        <td><strong><?= htmlspecialchars($report['employee_id'] ?? '') ?></strong></td>
                        <td><?= htmlspecialchars(($report['first_name'] ?? '') . ' ' . ($report['last_name'] ?? '')) ?></td>
                        <td><?= htmlspecialchars($report['department_name'] ?? 'N/A') ?></td>
                        <td><span class="badge bg-success"><?= (int)($report['present_days'] ?? 0) ?></span></td>
                        <td><span class="badge bg-danger"><?= (int)($report['absent_days'] ?? 0) ?></span></td>
                        <td><span class="badge bg-warning"><?= (int)($report['half_days'] ?? 0) ?></span></td>
                        <td><span class="badge bg-info"><?= (int)($report['leave_days'] ?? 0) ?></span></td>
                        <td><strong><?= (int)($report['total_days'] ?? 0) ?></strong></td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        <?php endif; ?>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>






