<?php declare(strict_types=1);
// Page-specific styles
$pageStyles = '
    .allocation-card {
      transition: transform 0.2s, box-shadow 0.2s;
      border-left: 4px solid #0d6efd;
    }
    .allocation-card.occupied {
      border-left-color: #dc3545;
    }
    .allocation-card.available {
      border-left-color: #198754;
    }
    .allocation-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .status-badge {
      font-size: 0.85rem;
      padding: 0.4rem 0.8rem;
    }
    .info-row {
      border-bottom: 1px solid #e9ecef;
      padding: 0.5rem 0;
    }
    .info-row:last-child {
      border-bottom: none;
    }
    .filter-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 12px;
    }
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Header Section -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-bed text-primary me-2"></i>Bed Allocation</h1>
            <p class="text-muted mb-0">Track which patient is allocated to which bed, when, and for how long</p>
          </div>
        </div>

        <!-- Filter Card -->
        <div class="card filter-card shadow-sm mb-4 border-0">
          <div class="card-body p-4">
            <form method="get" action="<?= htmlspecialchars($base) ?>/beds" class="row g-3">
              <div class="col-md-4">
                <label class="form-label text-white fw-semibold"><i class="fas fa-search me-2"></i>Search</label>
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Search by patient, ward, bed..." class="form-control form-control-lg" />
              </div>
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-filter me-2"></i>Status</label>
                <select name="status" class="form-select form-select-lg">
                  <option value="">All Status</option>
                  <option value="occupied" <?= (isset($status) && $status === 'occupied') ? 'selected' : '' ?>>Occupied</option>
                  <option value="available" <?= (isset($status) && $status === 'available') ? 'selected' : '' ?>>Available</option>
                </select>
              </div>
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-hospital me-2"></i>Ward</label>
                <input name="ward" value="<?= htmlspecialchars($ward ?? '') ?>" placeholder="Filter by ward..." class="form-control form-control-lg" />
              </div>
              <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-light btn-lg w-100 shadow-sm" type="submit">
                  <i class="fas fa-filter me-2"></i>Filter
                </button>
              </div>
            </form>
          </div>
        </div>

        <!-- Bed Status Table -->
        <div class="card shadow-sm border-0">
          <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="fas fa-table me-2"></i>Bed Allocation Status</h5>
          </div>
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th class="text-center">S.No</th>
                    <th>Patient Name</th>
                    <th>Ward</th>
                    <th>Room No</th>
                    <th>Bed No</th>
                    <th class="text-center">Status</th>
                    <th>Admit Date</th>
                    <th>Duration</th>
                    <th>Charges</th>
                    <th class="text-center">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($allocations)): ?>
                    <?php 
                    $sno = 1;
                    foreach ($allocations as $alloc): 
                      $isOccupied = isset($alloc['status']) && $alloc['status'] === 'Occupied';
                    ?>
                      <tr class="<?= $isOccupied ? 'table-danger' : 'table-success' ?>">
                        <td class="text-center fw-bold"><?= $sno++ ?></td>
                        <td>
                          <?php if ($isOccupied && !empty($alloc['patient_name'])): ?>
                            <strong class="text-dark"><?= htmlspecialchars($alloc['patient_name']) ?></strong>
                          <?php else: ?>
                            <span class="text-muted fst-italic">Available</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <i class="fas fa-hospital text-primary me-1"></i>
                          <strong><?= htmlspecialchars($alloc['ward'] ?? 'N/A') ?></strong>
                        </td>
                        <td>
                          <?php if (!empty($alloc['room_name'])): ?>
                            <i class="fas fa-door-open text-info me-1"></i>
                            <strong><?= htmlspecialchars($alloc['room_code'] ?? $alloc['room_name']) ?></strong>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <i class="fas fa-bed text-warning me-1"></i>
                          <strong class="text-dark"><?= htmlspecialchars($alloc['bed_number'] ?? 'N/A') ?></strong>
                        </td>
                        <td class="text-center">
                          <span class="badge bg-<?= $isOccupied ? 'danger' : 'success' ?> px-3 py-2">
                            <i class="fas fa-<?= $isOccupied ? 'times-circle' : 'check-circle' ?> me-1"></i>
                            <?= htmlspecialchars($alloc['status'] ?? 'Available') ?>
                          </span>
                        </td>
                        <td>
                          <?php if ($isOccupied && !empty($alloc['admit_date_formatted'])): ?>
                            <i class="fas fa-calendar-alt text-primary me-1"></i>
                            <strong><?= htmlspecialchars($alloc['admit_date_formatted']) ?></strong>
                            <?php if (!empty($alloc['admit_time'])): ?>
                              <small class="text-muted d-block"><?= htmlspecialchars($alloc['admit_time']) ?></small>
                            <?php endif; ?>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if ($isOccupied && !empty($alloc['duration_text'])): ?>
                            <i class="fas fa-clock text-info me-1"></i>
                            <span class="fw-bold text-primary"><?= htmlspecialchars($alloc['duration_text']) ?></span>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if (!empty($alloc['charge_per_day']) && (float)$alloc['charge_per_day'] > 0): ?>
                            <i class="fas fa-rupee-sign text-success me-1"></i>
                            <strong class="text-success"><?= htmlspecialchars($alloc['charge_display']) ?></strong>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td class="text-center">
                          <?php if ($isOccupied && !empty($alloc['admission_id'])): ?>
                            <a href="<?= htmlspecialchars($base) ?>/admissions/view?id=<?= urlencode((string)$alloc['admission_id']) ?>" class="btn btn-sm btn-outline-primary" title="View Details">
                              <i class="fas fa-eye"></i>
                            </a>
                          <?php else: ?>
                            <a href="<?= htmlspecialchars($base) ?>/admissions/add" class="btn btn-sm btn-success" title="Allocate Patient">
                              <i class="fas fa-plus"></i>
                            </a>
                          <?php endif; ?>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="10" class="text-center text-muted py-5">
                        <i class="fas fa-bed fa-3x d-block mb-3"></i>
                        <h5>No beds found</h5>
                        <p class="mb-0">No bed allocations available</p>
                      </td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <!-- Summary Statistics -->
        <?php if (!empty($allocations)): 
          $totalBeds = count($allocations);
          $occupiedBeds = 0;
          $availableBeds = 0;
          foreach ($allocations as $alloc) {
            if (isset($alloc['status']) && $alloc['status'] === 'Occupied') {
              $occupiedBeds++;
            } else {
              $availableBeds++;
            }
          }
        ?>
          <div class="row g-3 mt-3">
            <div class="col-md-4">
              <div class="card border-0 shadow-sm bg-primary text-white">
                <div class="card-body text-center">
                  <i class="fas fa-bed fa-2x mb-2"></i>
                  <h3 class="mb-0"><?= $totalBeds ?></h3>
                  <p class="mb-0">Total Beds</p>
                </div>
              </div>
            </div>
            <div class="col-md-4">
              <div class="card border-0 shadow-sm bg-danger text-white">
                <div class="card-body text-center">
                  <i class="fas fa-user-injured fa-2x mb-2"></i>
                  <h3 class="mb-0"><?= $occupiedBeds ?></h3>
                  <p class="mb-0">Occupied Beds</p>
                </div>
              </div>
            </div>
            <div class="col-md-4">
              <div class="card border-0 shadow-sm bg-success text-white">
                <div class="card-body text-center">
                  <i class="fas fa-check-circle fa-2x mb-2"></i>
                  <h3 class="mb-0"><?= $availableBeds ?></h3>
                  <p class="mb-0">Available Beds</p>
                </div>
              </div>
            </div>
          </div>
        <?php endif; ?>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>
