<?php
declare(strict_types=1);

class Bed extends Model
{
    public function all(?int $hospitalId = null): array
    {
        $sql = "SELECT id, ward, number, type, is_available FROM beds";
        if ($hospitalId !== null) {
            $sql .= " WHERE hospital_id = :hospital_id";
        }
        $sql .= " ORDER BY ward, number";
        if ($hospitalId !== null) {
            $stmt = $this->db()->prepare($sql);
            $stmt->execute([':hospital_id' => $hospitalId]);
        } else {
            $stmt = $this->db()->query($sql);
        }
        return $stmt->fetchAll();
    }

    public function create(array $data): int
    {
        $stmt = $this->db()->prepare("INSERT INTO beds (hospital_id, room_id, ward, number, type, is_available) VALUES (:hospital_id, :room_id, :ward, :number, :type, 1)");
        $stmt->execute([
            ':hospital_id' => $data['hospital_id'] ?? null,
            ':room_id' => isset($data['room_id']) && (int)$data['room_id'] > 0 ? (int)$data['room_id'] : null,
            ':ward' => $data['ward'] ?? '',
            ':number' => $data['number'] ?? '',
            ':type' => $data['type'] ?? null,
        ]);
        return (int)$this->db()->lastInsertId();
    }

    public function setAvailability(int $bedId, bool $available): void
    {
        $stmt = $this->db()->prepare("UPDATE beds SET is_available = :a WHERE id = :id");
        $stmt->execute([':a' => $available ? 1 : 0, ':id' => $bedId]);
    }

    public function countAvailable(?int $hospitalId = null): int
    {
        if ($hospitalId !== null) {
            $stmt = $this->db()->prepare('SELECT COUNT(*) FROM beds WHERE is_available = 1 AND hospital_id = :hospital_id');
            $stmt->execute([':hospital_id' => $hospitalId]);
        } else {
            $stmt = $this->db()->query('SELECT COUNT(*) FROM beds WHERE is_available = 1');
        }
        return (int)$stmt->fetchColumn();
    }
}
