<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Create Invoice') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="row justify-content-center">
          <div class="col-12 col-xl-10">
            <div class="card border-0 shadow-sm">
              <div class="card-body p-4">
                <h1 class="h4 mb-4"><i class="fas fa-file-invoice-dollar text-primary me-2"></i>Create Invoice</h1>
                <form method="post" action="<?= htmlspecialchars($base) ?>/billing/store" novalidate>
              <div class="row g-3">
                <div class="col-md-6">
                  <label class="form-label">Patient <span class="text-danger">*</span></label>
                  <select name="patient_id" class="form-select" required>
                    <option value="">Select patient</option>
                    <?php foreach (($patients ?? []) as $p): ?>
                      <option value="<?= (int)$p['id'] ?>"><?= htmlspecialchars(($p['first_name'] ?? '').' '.($p['last_name'] ?? '')) ?></option>
                    <?php endforeach; ?>
                  </select>
                </div>
              </div>

              <hr class="my-4" />
              <h2 class="h6">Items</h2>
              <div id="items" class="vstack gap-3">
                <div class="row g-2 align-items-end item-row">
                  <div class="col-md-6">
                    <label class="form-label">Description</label>
                    <input type="text" name="items[0][description]" class="form-control" placeholder="Consultation">
                  </div>
                  <div class="col-md-2">
                    <label class="form-label">Qty</label>
                    <input type="number" step="0.01" name="items[0][qty]" class="form-control" value="1">
                  </div>
                  <div class="col-md-2">
                    <label class="form-label">Unit Price</label>
                    <input type="number" step="0.01" name="items[0][unit_price]" class="form-control" value="0">
                  </div>
                  <div class="col-md-2">
                    <button type="button" class="btn btn-outline-danger remove-item d-none">Remove</button>
                  </div>
                </div>
              </div>
              <div class="mt-3">
                <button type="button" id="addItem" class="btn btn-outline-primary">Add Item</button>
              </div>

              <div class="mt-4 d-flex gap-2">
                <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Create</button>
                <a href="<?= htmlspecialchars($base) ?>/billing" class="btn btn-outline-secondary">Cancel</a>
              </div>
            </form>
              </div>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script>
    (function(){
      let index = 1;
      const items = document.getElementById('items');
      document.getElementById('addItem').addEventListener('click', function(){
        const row = document.createElement('div');
        row.className = 'row g-2 align-items-end item-row';
        row.innerHTML = `
          <div class="col-md-6">
            <label class="form-label">Description</label>
            <input type="text" name="items[${index}][description]" class="form-control" placeholder="Service name">
          </div>
          <div class="col-md-2">
            <label class="form-label">Qty</label>
            <input type="number" step="0.01" name="items[${index}][qty]" class="form-control" value="1">
          </div>
          <div class="col-md-2">
            <label class="form-label">Unit Price</label>
            <input type="number" step="0.01" name="items[${index}][unit_price]" class="form-control" value="0">
          </div>
          <div class="col-md-2">
            <button type="button" class="btn btn-outline-danger remove-item">Remove</button>
          </div>`;
        items.appendChild(row);
        index++;
      });
      items.addEventListener('click', function(e){
        if (e.target.classList.contains('remove-item')) {
          const r = e.target.closest('.item-row');
          if (r) r.remove();
        }
      });
    })();
  </script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
