<?php declare(strict_types=1);
// Page-specific styles
$pageStyles = '
    .kpi-card{border:0;box-shadow:0 1px 2px rgba(0,0,0,.06),0 4px 10px rgba(0,0,0,.04)}
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3">
          <div>
            <h1 class="h4 mb-1"><i class="fas fa-file-invoice text-primary me-2"></i>Invoices</h1>
            <div class="text-muted small">Manage invoices and payments</div>
          </div>
          <div class="mt-2 mt-md-0 d-flex gap-2">
            <a href="<?= htmlspecialchars($base) ?>/billing/add" class="btn btn-primary"><i class="fas fa-plus-circle me-2"></i>New Invoice</a>
          </div>
        </div>

        <div class="row g-3 mb-3">
          <div class="col-12 col-md-4">
            <div class="card kpi-card">
              <div class="card-body d-flex justify-content-between align-items-center">
                <div>
                  <div class="text-muted small">Total Invoices</div>
                </div>
                <i class="fas fa-receipt text-primary"></i>
              </div>
            </div>
          </div>
          <div class="col-12 col-md-4">
            <div class="card kpi-card">
              <div class="card-body d-flex justify-content-between align-items-center">
                <div>
                  <div class="text-muted small">Total Collected</div>
                </div>
                <i class="fas fa-indian-rupee-sign text-success"></i>
              </div>
            </div>
          </div>
          <div class="col-12 col-md-4">
            <div class="card kpi-card">
              <div class="card-body d-flex justify-content-between align-items-center">
                <div>
                  <div class="text-muted small">Outstanding</div>
                </div>
                <i class="fas fa-wallet text-warning"></i>
              </div>
            </div>
          </div>
        </div>

        <div class="card border-0 shadow-sm">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>ID</th>
                    <th>Date</th>
                    <th>Patient</th>
                    <th>Total</th>
                    <th>Status</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                <?php if (!empty($invoices)): ?>
                  <?php foreach ($invoices as $i): ?>
                  <tr>
                    <td><?= (int)$i['id'] ?></td>
                    <td><?= htmlspecialchars($i['invoice_date'] ?? '') ?></td>
                    <td><?= htmlspecialchars(($i['p_first'] ?? '').' '.($i['p_last'] ?? '')) ?></td>
                    <td>₹ <?= number_format((float)($i['total'] ?? 0), 2) ?></td>
                    <td><span class="badge <?= ($i['status'] ?? '') === 'Paid' ? 'bg-success' : 'bg-warning text-dark' ?>"><?= htmlspecialchars($i['status'] ?? '') ?></span></td>
                    <td><a class="btn btn-sm btn-outline-primary" href="<?= htmlspecialchars($base) ?>/billing/view?id=<?= urlencode((string)$i['id']) ?>">View</a></td>
                  </tr>
                  <?php endforeach; ?>
                <?php else: ?>
                  <tr><td colspan="6" class="text-center text-muted py-4">No invoices found.</td></tr>
                <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>
