<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Invoice') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
    <a href="<?= htmlspecialchars($base) ?>/billing" class="btn btn-link">&larr; Back to Invoices</a>
    <div class="row mt-2">
      <div class="col-12 col-xl-10">
        <div class="card border-0 shadow-sm mb-3">
          <div class="card-body p-4">
            <div class="d-flex justify-content-between align-items-start">
              <div>
                <h1 class="h4 mb-1">Invoice #<?= (int)($invoice['id'] ?? 0) ?></h1>
                <div class="text-secondary">Date: <?= htmlspecialchars($invoice['invoice_date'] ?? '') ?></div>
                <div class="text-secondary">Patient: <?= htmlspecialchars(($invoice['p_first'] ?? '').' '.($invoice['p_last'] ?? '')) ?></div>
              </div>
              <div>
                <span class="badge <?= ($invoice['status'] ?? '') === 'Paid' ? 'bg-success' : 'bg-warning text-dark' ?>"><?= htmlspecialchars($invoice['status'] ?? '') ?></span>
              </div>
            </div>

            <div class="table-responsive mt-4">
              <table class="table">
                <thead>
                  <tr>
                    <th>Description</th>
                    <th class="text-end">Qty</th>
                    <th class="text-end">Unit Price</th>
                    <th class="text-end">Amount</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $total = 0.0; foreach (($invoice['items'] ?? []) as $it): $total += (float)($it['amount'] ?? 0); ?>
                  <tr>
                    <td><?= htmlspecialchars($it['description'] ?? '') ?></td>
                    <td class="text-end"><?= number_format((float)($it['qty'] ?? 0), 2) ?></td>
                    <td class="text-end">₹ <?= number_format((float)($it['unit_price'] ?? 0), 2) ?></td>
                    <td class="text-end">₹ <?= number_format((float)($it['amount'] ?? 0), 2) ?></td>
                  </tr>
                  <?php endforeach; ?>
                </tbody>
                <tfoot>
                  <tr>
                    <th colspan="3" class="text-end">Total</th>
                    <th class="text-end">₹ <?= number_format($total, 2) ?></th>
                  </tr>
                </tfoot>
              </table>
            </div>
          </div>
        </div>

        <div class="row g-3">
          <div class="col-12 col-lg-6">
            <div class="card border-0 shadow-sm h-100">
              <div class="card-body p-4">
                <h2 class="h6 mb-3">Payments</h2>
                <div class="table-responsive">
                  <table class="table table-sm">
                    <thead>
                      <tr>
                        <th>Date</th>
                        <th class="text-end">Amount</th>
                        <th>Method</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $paid = 0.0; foreach (($invoice['payments'] ?? []) as $p): $paid += (float)($p['amount'] ?? 0); ?>
                      <tr>
                        <td><?= htmlspecialchars($p['paid_at'] ?? '') ?></td>
                        <td class="text-end">₹ <?= number_format((float)($p['amount'] ?? 0), 2) ?></td>
                        <td><?= htmlspecialchars($p['method'] ?? '') ?></td>
                      </tr>
                      <?php endforeach; ?>
                      <?php if (empty($invoice['payments'])): ?>
                        <tr><td colspan="3" class="text-muted">No payments yet.</td></tr>
                      <?php endif; ?>
                    </tbody>
                    <tfoot>
                      <tr>
                        <th>Total Paid</th>
                        <th class="text-end">₹ <?= number_format($paid, 2) ?></th>
                        <th></th>
                      </tr>
                      <tr>
                        <th>Balance</th>
                        <th class="text-end">₹ <?= number_format(max(0, ((float)($invoice['total'] ?? 0)) - $paid), 2) ?></th>
                        <th></th>
                      </tr>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="col-12 col-lg-6">
            <div class="card border-0 shadow-sm h-100">
              <div class="card-body p-4">
                <h2 class="h6 mb-3">Add Payment</h2>
                <form method="post" action="<?= htmlspecialchars($base) ?>/billing/add-payment" class="row g-3">
                  <input type="hidden" name="invoice_id" value="<?= (int)($invoice['id'] ?? 0) ?>">
                  <div class="col-md-6">
                    <label class="form-label">Amount</label>
                    <input type="number" step="0.01" name="amount" class="form-control" required>
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Method</label>
                    <input type="text" name="method" class="form-control" placeholder="Cash / Card / UPI">
                  </div>
                  <div class="col-12 d-flex gap-2">
                    <button type="submit" class="btn btn-primary">Add Payment</button>
                    <a href="<?= htmlspecialchars($base) ?>/billing" class="btn btn-outline-secondary">Back</a>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
