<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Add Charge') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
  <style>
    .form-section {
      background: #f8f9fa;
      border-radius: 8px;
      padding: 1.5rem;
      margin-bottom: 1.5rem;
    }
    .section-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: #495057;
      margin-bottom: 1rem;
      padding-bottom: 0.5rem;
      border-bottom: 2px solid #dee2e6;
    }
  </style>
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-primary text-white">
            <h2 class="h5 mb-0"><i class="fas fa-plus-circle me-2"></i>Add New Charge</h2>
          </div>
          <div class="card-body p-4">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? null;
              $formErrors = $_SESSION['form_errors'] ?? [];
              $old = $_SESSION['old'] ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>
            <?php endif; ?>
            
            <form method="post" action="<?= htmlspecialchars($base) ?>/charges/store">
              <!-- Basic Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-info-circle me-2"></i>Basic Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Charge Name <span class="text-danger">*</span></label>
                    <input name="name" value="<?= htmlspecialchars($old['name'] ?? '') ?>" class="form-control form-control-lg" required placeholder="e.g., General Consultation" />
                    <?php if (!empty($formErrors['name'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['name']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Charge Code</label>
                    <input name="code" value="<?= htmlspecialchars($old['code'] ?? '') ?>" class="form-control form-control-lg" placeholder="e.g., CON-GEN-001" />
                    <?php if (!empty($formErrors['code'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['code']) ?></div><?php endif; ?>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Charge Type <span class="text-danger">*</span></label>
                    <select name="charge_type" class="form-select form-select-lg" required>
                      <?php foreach (($chargeTypes ?? []) as $type): ?>
                        <option value="<?= htmlspecialchars($type) ?>" <?= (isset($old['charge_type']) && $old['charge_type'] === $type) ? 'selected' : '' ?>>
                          <?= htmlspecialchars($type) ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                    <?php if (!empty($formErrors['charge_type'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['charge_type']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Category</label>
                    <input name="category" value="<?= htmlspecialchars($old['category'] ?? '') ?>" class="form-control form-control-lg" placeholder="e.g., OPD, IPD, Emergency" />
                    <?php if (!empty($formErrors['category'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['category']) ?></div><?php endif; ?>
                  </div>
                </div>
              </div>

              <!-- Pricing Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-rupee-sign me-2"></i>Pricing Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Amount (₹) <span class="text-danger">*</span></label>
                    <div class="input-group input-group-lg">
                      <span class="input-group-text bg-light">₹</span>
                      <input type="number" name="amount" value="<?= htmlspecialchars($old['amount'] ?? '0.00') ?>" step="0.01" min="0" class="form-control" required placeholder="0.00" />
                    </div>
                    <?php if (!empty($formErrors['amount'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['amount']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Tax Percentage (%)</label>
                    <div class="input-group input-group-lg">
                      <input type="number" name="tax_percentage" value="<?= htmlspecialchars($old['tax_percentage'] ?? '0.00') ?>" step="0.01" min="0" max="100" class="form-control" placeholder="0.00" />
                      <span class="input-group-text bg-light">%</span>
                    </div>
                    <?php if (!empty($formErrors['tax_percentage'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['tax_percentage']) ?></div><?php endif; ?>
                  </div>
                </div>
              </div>

              <!-- Additional Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-building me-2"></i>Additional Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Department</label>
                    <select name="department_id" class="form-select form-select-lg">
                      <option value="">-- Select Department (Optional) --</option>
                      <?php foreach (($departments ?? []) as $dept): ?>
                        <option value="<?= (int)($dept['id'] ?? 0) ?>" <?= (isset($old['department_id']) && (int)$old['department_id'] === (int)($dept['id'] ?? 0)) ? 'selected' : '' ?>>
                          <?= htmlspecialchars($dept['name'] ?? '') ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Status</label>
                    <select name="status" class="form-select form-select-lg">
                      <option value="1" <?= ((isset($old['status']) && (int)$old['status'] === 1) || !isset($old['status'])) ? 'selected' : '' ?>>Active</option>
                      <option value="0" <?= (isset($old['status']) && (int)$old['status'] === 0) ? 'selected' : '' ?>>Inactive</option>
                    </select>
                  </div>
                </div>
                <div class="mb-3">
                  <label class="form-label fw-semibold">Description</label>
                  <textarea name="description" class="form-control" rows="4" placeholder="Enter charge description..."><?= htmlspecialchars($old['description'] ?? '') ?></textarea>
                </div>
              </div>

              <div class="d-flex justify-content-end gap-2 mt-4">
                <a class="btn btn-secondary btn-lg" href="<?= htmlspecialchars($base) ?>/charges">
                  <i class="fas fa-times me-2"></i>Cancel
                </a>
                <button class="btn btn-primary btn-lg" type="submit">
                  <i class="fas fa-save me-2"></i>Save Charge
                </button>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>






