<?php declare(strict_types=1);
// Page-specific styles
$pageStyles = '
    .charge-card {
      transition: transform 0.2s, box-shadow 0.2s;
      border-left: 4px solid #0d6efd;
    }
    .charge-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .charge-type-badge {
      font-size: 0.75rem;
      padding: 0.35rem 0.65rem;
    }
    .amount-display {
      font-size: 1.25rem;
      font-weight: 600;
      color: #198754;
    }
    .filter-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 12px;
    }
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Header Section -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-money-bill-wave text-primary me-2"></i>Charges Management</h1>
            <p class="text-muted mb-0">Manage hospital charges, fees, and pricing</p>
          </div>
          <div class="mt-3 mt-md-0">
            <a href="<?= htmlspecialchars($base) ?>/charges/add" class="btn btn-primary btn-lg shadow-sm">
              <i class="fas fa-plus-circle me-2"></i>Add New Charge
            </a>
          </div>
        </div>

        <!-- Filter Card -->
        <div class="card filter-card shadow-sm mb-4 border-0">
          <div class="card-body p-4">
            <form method="get" action="<?= htmlspecialchars($base) ?>/charges" class="row g-3">
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-search me-2"></i>Search</label>
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Search charges..." class="form-control form-control-lg" />
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-filter me-2"></i>Type</label>
                <select name="charge_type" class="form-select form-select-lg">
                  <option value="">All Types</option>
                  <?php foreach (($chargeTypes ?? []) as $type): ?>
                    <option value="<?= htmlspecialchars($type) ?>" <?= (isset($charge_type) && $charge_type === $type) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($type) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-building me-2"></i>Department</label>
                <select name="department_id" class="form-select form-select-lg">
                  <option value="">All Departments</option>
                  <?php foreach (($departments ?? []) as $dept): ?>
                    <option value="<?= (int)($dept['id'] ?? 0) ?>" <?= (isset($department_id) && (int)$department_id === (int)($dept['id'] ?? 0)) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($dept['name'] ?? '') ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-toggle-on me-2"></i>Status</label>
                <select name="status" class="form-select form-select-lg">
                  <option value="">All</option>
                  <option value="1" <?= (isset($status) && $status === 1) ? 'selected' : '' ?>>Active</option>
                  <option value="0" <?= (isset($status) && $status === 0) ? 'selected' : '' ?>>Inactive</option>
                </select>
              </div>
              <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-light btn-lg w-100 shadow-sm" type="submit">
                  <i class="fas fa-filter me-2"></i>Filter
                </button>
              </div>
            </form>
          </div>
        </div>

        <!-- Charges Grid -->
        <?php if (!empty($charges)): ?>
          <div class="row g-4">
            <?php foreach ($charges as $charge): ?>
              <div class="col-md-6 col-lg-4">
                <div class="card charge-card shadow-sm h-100">
                  <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                      <div>
                        <h5 class="card-title mb-1 fw-bold"><?= htmlspecialchars($charge['name'] ?? '') ?></h5>
                        <?php if (!empty($charge['code'])): ?>
                          <span class="badge bg-secondary charge-type-badge"><?= htmlspecialchars($charge['code']) ?></span>
                        <?php endif; ?>
                      </div>
                      <span class="badge bg-<?= ((isset($charge['status']) && (int)$charge['status'] === 1) ? 'success' : 'secondary') ?> charge-type-badge">
                        <?= ((isset($charge['status']) && (int)$charge['status'] === 1) ? 'Active' : 'Inactive') ?>
                      </span>
                    </div>
                    
                    <div class="mb-3">
                      <span class="badge bg-primary charge-type-badge">
                        <i class="fas fa-tag me-1"></i><?= htmlspecialchars($charge['charge_type'] ?? 'Other') ?>
                      </span>
                      <?php if (!empty($charge['category'])): ?>
                        <span class="badge bg-info charge-type-badge ms-1">
                          <?= htmlspecialchars($charge['category']) ?>
                        </span>
                      <?php endif; ?>
                    </div>

                    <div class="mb-3">
                      <div class="amount-display">
                        ₹<?= number_format((float)($charge['amount'] ?? 0), 2) ?>
                        <?php if ((float)($charge['tax_percentage'] ?? 0) > 0): ?>
                          <small class="text-muted">+ <?= number_format((float)$charge['tax_percentage'], 2) ?>% tax</small>
                        <?php endif; ?>
                      </div>
                    </div>

                    <?php if (!empty($charge['department_name'])): ?>
                      <p class="text-muted small mb-2">
                        <i class="fas fa-building me-1"></i><?= htmlspecialchars($charge['department_name']) ?>
                      </p>
                    <?php endif; ?>

                    <?php if (!empty($charge['description'])): ?>
                      <p class="text-muted small mb-3" style="display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden;">
                        <?= htmlspecialchars($charge['description']) ?>
                      </p>
                    <?php endif; ?>

                    <div class="d-flex gap-2 mt-auto">
                      <a href="<?= htmlspecialchars($base) ?>/charges/view?id=<?= urlencode((string)($charge['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-secondary flex-fill">
                        <i class="fas fa-eye me-1"></i>View
                      </a>
                      <a href="<?= htmlspecialchars($base) ?>/charges/edit?id=<?= urlencode((string)($charge['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-primary flex-fill">
                        <i class="fas fa-edit me-1"></i>Edit
                      </a>
                      <?php if (isset($charge['status']) && (int)$charge['status'] === 1): ?>
                        <form method="post" action="<?= htmlspecialchars($base) ?>/charges/deactivate" style="display:inline-block" onsubmit="return confirm('Deactivate this charge?');" class="flex-fill">
                          <input type="hidden" name="id" value="<?= (int)($charge['id'] ?? 0) ?>">
                          <button type="submit" class="btn btn-sm btn-outline-warning w-100">
                            <i class="fas fa-ban me-1"></i>Deactivate
                          </button>
                        </form>
                      <?php else: ?>
                        <form method="post" action="<?= htmlspecialchars($base) ?>/charges/restore" style="display:inline-block" onsubmit="return confirm('Restore this charge?');" class="flex-fill">
                          <input type="hidden" name="id" value="<?= (int)($charge['id'] ?? 0) ?>">
                          <button type="submit" class="btn btn-sm btn-outline-success w-100">
                            <i class="fas fa-check me-1"></i>Restore
                          </button>
                        </form>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        <?php else: ?>
          <div class="card shadow-sm border-0">
            <div class="card-body text-center py-5">
              <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
              <h5 class="text-muted">No charges found</h5>
              <p class="text-muted">Get started by adding your first charge</p>
              <a href="<?= htmlspecialchars($base) ?>/charges/add" class="btn btn-primary">
                <i class="fas fa-plus-circle me-2"></i>Add New Charge
              </a>
            </div>
          </div>
        <?php endif; ?>

        <!-- Pagination -->
        <?php
          $total = (int)($total ?? 0);
          $perPage = (int)($perPage ?? 20);
          $page = (int)($page ?? 1);
          $pages = $perPage > 0 ? (int)ceil($total / $perPage) : 1;
        ?>
        <?php if ($pages > 1): ?>
          <nav class="mt-4" aria-label="Charges pagination">
            <ul class="pagination justify-content-center">
              <?php for ($p = 1; $p <= $pages; $p++): ?>
                <li class="page-item <?= $p === $page ? 'active' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/charges?page=<?= $p ?>&q=<?= urlencode((string)($q ?? '')) ?>&status=<?= urlencode((string)($status ?? '')) ?>&charge_type=<?= urlencode((string)($charge_type ?? '')) ?>&department_id=<?= urlencode((string)($department_id ?? '')) ?>"><?= $p ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>






