<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Charge Details') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
  <style>
    .info-card {
      border-left: 4px solid #0d6efd;
      transition: transform 0.2s;
    }
    .info-card:hover {
      transform: translateX(5px);
    }
    .amount-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 12px;
    }
  </style>
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-money-bill-wave text-primary me-2"></i>Charge Details</h1>
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= htmlspecialchars($base) ?>/charges">Charges</a></li>
                <li class="breadcrumb-item active">Details</li>
              </ol>
            </nav>
          </div>
          <div>
            <a class="btn btn-outline-primary" href="<?= htmlspecialchars($base) ?>/charges/edit?id=<?= urlencode((string)($charge['id'] ?? 0)) ?>">
              <i class="fas fa-edit me-2"></i>Edit
            </a>
            <a class="btn btn-secondary ms-2" href="<?= htmlspecialchars($base) ?>/charges">
              <i class="fas fa-arrow-left me-2"></i>Back
            </a>
          </div>
        </div>

        <div class="row g-4">
          <!-- Amount Card -->
          <div class="col-md-4">
            <div class="card amount-card shadow-lg border-0">
              <div class="card-body text-center p-4">
                <i class="fas fa-rupee-sign fa-3x mb-3 opacity-75"></i>
                <h3 class="mb-2">Total Amount</h3>
                <div class="display-4 fw-bold mb-2">₹<?= number_format((float)($charge['amount'] ?? 0), 2) ?></div>
                <?php if ((float)($charge['tax_percentage'] ?? 0) > 0): ?>
                  <p class="mb-0 opacity-75">
                    <small>+ <?= number_format((float)$charge['tax_percentage'], 2) ?>% tax</small>
                  </p>
                  <?php 
                    $taxAmount = ((float)($charge['amount'] ?? 0) * (float)($charge['tax_percentage'] ?? 0)) / 100;
                    $totalAmount = (float)($charge['amount'] ?? 0) + $taxAmount;
                  ?>
                  <p class="h5 mt-2 mb-0">Total: ₹<?= number_format($totalAmount, 2) ?></p>
                <?php endif; ?>
              </div>
            </div>
          </div>

          <!-- Basic Information -->
          <div class="col-md-8">
            <div class="card info-card shadow-sm border-0">
              <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Basic Information</h5>
              </div>
              <div class="card-body">
                <div class="row g-3">
                  <div class="col-md-6">
                    <label class="text-muted small">Charge Name</label>
                    <p class="fw-semibold mb-0"><?= htmlspecialchars($charge['name'] ?? 'N/A') ?></p>
                  </div>
                  <div class="col-md-6">
                    <label class="text-muted small">Charge Code</label>
                    <p class="fw-semibold mb-0">
                      <?= !empty($charge['code']) ? htmlspecialchars($charge['code']) : '<span class="text-muted">N/A</span>' ?>
                    </p>
                  </div>
                  <div class="col-md-6">
                    <label class="text-muted small">Charge Type</label>
                    <p class="mb-0">
                      <span class="badge bg-primary"><?= htmlspecialchars($charge['charge_type'] ?? 'Other') ?></span>
                    </p>
                  </div>
                  <div class="col-md-6">
                    <label class="text-muted small">Category</label>
                    <p class="fw-semibold mb-0">
                      <?= !empty($charge['category']) ? htmlspecialchars($charge['category']) : '<span class="text-muted">N/A</span>' ?>
                    </p>
                  </div>
                  <div class="col-md-6">
                    <label class="text-muted small">Department</label>
                    <p class="fw-semibold mb-0">
                      <?= !empty($charge['department_name']) ? htmlspecialchars($charge['department_name']) : '<span class="text-muted">N/A</span>' ?>
                    </p>
                  </div>
                  <div class="col-md-6">
                    <label class="text-muted small">Status</label>
                    <p class="mb-0">
                      <?= ((isset($charge['status']) && (int)$charge['status'] === 1) ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>') ?>
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Description -->
          <?php if (!empty($charge['description'])): ?>
            <div class="col-12">
              <div class="card shadow-sm border-0">
                <div class="card-header bg-light">
                  <h5 class="mb-0"><i class="fas fa-align-left me-2"></i>Description</h5>
                </div>
                <div class="card-body">
                  <p class="mb-0"><?= nl2br(htmlspecialchars($charge['description'])) ?></p>
                </div>
              </div>
            </div>
          <?php endif; ?>

          <!-- Additional Details -->
          <div class="col-12">
            <div class="card shadow-sm border-0">
              <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fas fa-clock me-2"></i>Additional Details</h5>
              </div>
              <div class="card-body">
                <div class="row g-3">
                  <div class="col-md-4">
                    <label class="text-muted small">Created At</label>
                    <p class="fw-semibold mb-0"><?= htmlspecialchars($charge['created_at'] ?? 'N/A') ?></p>
                  </div>
                  <div class="col-md-4">
                    <label class="text-muted small">Updated At</label>
                    <p class="fw-semibold mb-0"><?= htmlspecialchars($charge['updated_at'] ?? 'N/A') ?></p>
                  </div>
                  <div class="col-md-4">
                    <label class="text-muted small">Charge ID</label>
                    <p class="fw-semibold mb-0">#<?= (int)($charge['id'] ?? 0) ?></p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>






