<?php declare(strict_types=1); 
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php';
?>
<div class="container-fluid">
  <div class="row">
    <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
    <main class="content p-4">
      <!-- Page Header -->
      <div class="page-header mb-4">
        <div class="d-flex justify-content-between align-items-start flex-wrap">
          <div>
            <h1 class="page-title">
              <i class="fas fa-tachometer-alt text-primary me-2"></i>
              <span>Dashboard Overview</span>
            </h1>
            <p class="page-subtitle">Welcome back! Here's what's happening at <?= htmlspecialchars($hospitalName ?? 'your hospital') ?> today.</p>
          </div>
          <div class="d-flex gap-2 mt-3 mt-md-0">
            <a href="<?= htmlspecialchars($base ?? '') ?>/appointments/add" class="btn btn-primary shadow-sm">
              <i class="fas fa-calendar-plus me-2"></i>New Appointment
            </a>
            <a href="<?= htmlspecialchars($base ?? '') ?>/patients/add" class="btn btn-outline-primary shadow-sm">
              <i class="fas fa-user-plus me-2"></i>Add Patient
            </a>
          </div>
        </div>
      </div>

      <!-- KPI Cards -->
      <div class="row g-4 mb-4">
        <?php 
        $kpis = [
          [
            'label' => 'Total Patients', 
            'value' => (int)($stats['patients'] ?? 0), 
            'icon' => 'fa-user-injured', 
            'color' => 'primary',
            'gradient' => 'linear-gradient(135deg, #2563eb 0%, #3b82f6 100%)'
          ],
          [
            'label' => 'Active Doctors', 
            'value' => (int)($stats['doctors'] ?? 0), 
            'icon' => 'fa-user-doctor', 
            'color' => 'success',
            'gradient' => 'linear-gradient(135deg, #10b981 0%, #34d399 100%)'
          ],
          [
            'label' => 'Today\'s Appointments', 
            'value' => (int)($stats['appointments'] ?? 0), 
            'icon' => 'fa-calendar-check', 
            'color' => 'warning',
            'gradient' => 'linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%)'
          ],
          [
            'label' => 'Available Beds', 
            'value' => (int)($stats['beds_available'] ?? 0), 
            'icon' => 'fa-bed', 
            'color' => 'info',
            'gradient' => 'linear-gradient(135deg, #06b6d4 0%, #22d3ee 100%)'
          ],
        ];
        foreach ($kpis as $index => $kpi): 
        ?>
          <div class="col-12 col-md-6 col-xl-3">
            <div class="card stat-card fade-in" style="border-left: 4px solid var(--bs-<?= $kpi['color'] ?>); animation-delay: <?= $index * 0.1 ?>s;">
              <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                  <div class="flex-grow-1">
                    <div class="stat-label text-<?= $kpi['color'] ?>"><?= htmlspecialchars($kpi['label']) ?></div>
                    <div class="stat-value text-dark"><?= number_format($kpi['value']) ?></div>
                  </div>
                  <div class="stat-badge" style="background: <?= $kpi['gradient'] ?>;">
                    <i class="fas <?= htmlspecialchars($kpi['icon']) ?> text-white"></i>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>

      <!-- Charts and Today Stats -->
      <div class="row g-4 mb-4">
        <div class="col-12 col-lg-8">
          <div class="card shadow-md h-100">
            <div class="card-header">
              <div class="d-flex align-items-center justify-content-between">
                <h5 class="mb-0">
                  <i class="fas fa-chart-line text-primary me-2"></i>Patient Flow Analysis
                </h5>
                <div class="btn-group btn-group-sm" role="group">
                  <button class="btn btn-outline-primary active" type="button">Week</button>
                  <button class="btn btn-outline-primary" type="button">Month</button>
                  <button class="btn btn-outline-primary" type="button">Year</button>
                </div>
              </div>
            </div>
            <div class="card-body">
              <canvas id="chartPatientFlow" height="120"></canvas>
            </div>
          </div>
        </div>
        
        <div class="col-12 col-lg-4">
          <div class="card shadow-md h-100">
            <div class="card-header">
              <h5 class="mb-0">
                <i class="fas fa-calendar-day text-primary me-2"></i>Today's Summary
              </h5>
            </div>
            <div class="card-body">
              <div class="list-group list-group-flush">
                <div class="list-group-item px-0 d-flex justify-content-between align-items-center border-0 border-bottom">
                  <div class="d-flex align-items-center">
                    <div class="stat-icon-small bg-primary bg-opacity-10 text-primary me-3">
                      <i class="fas fa-calendar-check"></i>
                    </div>
                    <span class="fw-medium">Appointments</span>
                  </div>
                  <span class="badge bg-primary fs-6 px-3 py-2"><?= (int)($today['appointments'] ?? 0) ?></span>
                </div>
                <div class="list-group-item px-0 d-flex justify-content-between align-items-center border-0 border-bottom">
                  <div class="d-flex align-items-center">
                    <div class="stat-icon-small bg-success bg-opacity-10 text-success me-3">
                      <i class="fas fa-hospital"></i>
                    </div>
                    <span class="fw-medium">Admissions</span>
                  </div>
                  <span class="badge bg-success fs-6 px-3 py-2"><?= (int)($today['admissions'] ?? 0) ?></span>
                </div>
                <div class="list-group-item px-0 d-flex justify-content-between align-items-center border-0">
                  <div class="d-flex align-items-center">
                    <div class="stat-icon-small bg-info bg-opacity-10 text-info me-3">
                      <i class="fas fa-user-check"></i>
                    </div>
                    <span class="fw-medium">Discharges</span>
                  </div>
                  <span class="badge bg-info fs-6 px-3 py-2"><?= (int)($today['discharges'] ?? 0) ?></span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Recent Appointments -->
      <div class="card shadow-md">
        <div class="card-header">
          <div class="d-flex align-items-center justify-content-between">
            <h5 class="mb-0">
              <i class="fas fa-list text-primary me-2"></i>Recent Appointments
            </h5>
            <a href="<?= htmlspecialchars($base ?? '') ?>/appointments" class="btn btn-sm btn-outline-primary">
              View All <i class="fas fa-arrow-right ms-1"></i>
            </a>
          </div>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Patient</th>
                  <th>Doctor</th>
                  <th>Date & Time</th>
                  <th>Status</th>
                  <th class="text-end">Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php if (!empty($recentAppointments)): ?>
                  <?php foreach ($recentAppointments as $row): ?>
                    <tr>
                      <td><span class="badge bg-secondary">#<?= (int)($row['id'] ?? 0) ?></span></td>
                      <td>
                        <div class="fw-medium"><?= htmlspecialchars($row['patient'] ?? '') ?></div>
                      </td>
                      <td><?= htmlspecialchars($row['doctor'] ?? '') ?></td>
                      <td>
                        <div class="text-nowrap"><?= htmlspecialchars($row['scheduled_at'] ?? '') ?></div>
                      </td>
                      <td>
                        <?php $st = strtolower((string)($row['status'] ?? '')); ?>
                        <span class="badge bg-<?= $st === 'completed' ? 'success' : ($st === 'cancelled' ? 'danger' : 'warning') ?>">
                          <?= htmlspecialchars((string)($row['status'] ?? '')) ?>
                        </span>
                      </td>
                      <td class="text-end">
                        <a href="<?= htmlspecialchars($base ?? '') ?>/appointments/view?id=<?= (int)($row['id'] ?? 0) ?>" class="btn btn-sm btn-outline-primary">
                          <i class="fas fa-eye"></i>
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                <?php else: ?>
                  <tr>
                    <td colspan="6" class="text-center text-muted py-4">
                      <i class="fas fa-calendar-times fa-2x mb-2"></i>
                      <p class="mb-0">No recent appointments found.</p>
                    </td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </main>
  </div>
</div>

<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
(function(){
  const ctx = document.getElementById('chartPatientFlow');
  if (ctx && window.Chart){
    const labels = ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'];
    const appts = [12, 19, 14, 20, 16, 9, 11];
    const admits = [4, 6, 5, 7, 6, 3, 4];
    const disch = [3, 5, 4, 6, 5, 2, 3];
    new Chart(ctx, {
      type: 'line',
      data: {
        labels,
        datasets: [
          { 
            label: 'Appointments', 
            data: appts, 
            borderColor: '#2563eb', 
            backgroundColor: 'rgba(37, 99, 235, 0.1)', 
            tension: 0.4, 
            fill: true,
            pointRadius: 4,
            pointHoverRadius: 6
          },
          { 
            label: 'Admissions', 
            data: admits, 
            borderColor: '#10b981', 
            backgroundColor: 'rgba(16, 185, 129, 0.1)', 
            tension: 0.4, 
            fill: true,
            pointRadius: 4,
            pointHoverRadius: 6
          },
          { 
            label: 'Discharges', 
            data: disch, 
            borderColor: '#06b6d4', 
            backgroundColor: 'rgba(6, 182, 212, 0.1)', 
            tension: 0.4, 
            fill: true,
            pointRadius: 4,
            pointHoverRadius: 6
          },
        ]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: { 
          legend: { 
            position: 'bottom',
            labels: {
              padding: 15,
              usePointStyle: true
            }
          },
          tooltip: {
            mode: 'index',
            intersect: false
          }
        },
        scales: {
          x: { 
            grid: { display: false },
            ticks: {
              font: {
                size: 12
              }
            }
          },
          y: { 
            beginAtZero: true, 
            ticks: { stepSize: 5 },
            grid: {
              color: 'rgba(0, 0, 0, 0.05)'
            }
          }
        },
        interaction: {
          mode: 'nearest',
          axis: 'x',
          intersect: false
        }
      }
    });
  }
})();
</script>

<style>
/* Dashboard specific styles */
.page-header {
  margin-bottom: 2rem;
  padding-bottom: 1rem;
  border-bottom: 2px solid #e5e7eb;
}

.page-title {
  font-size: 1.875rem;
  font-weight: 700;
  color: #111827;
  margin: 0;
  display: flex;
  align-items: center;
}

.page-subtitle {
  font-size: 1rem;
  color: #6b7280;
  margin-top: 0.5rem;
  margin-bottom: 0;
}

.stat-card {
  border: none;
  border-radius: 0.75rem;
  box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
  position: relative;
  overflow: hidden;
  background: white;
}

.stat-card:hover {
  box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
  transform: translateY(-2px);
}

.stat-label {
  font-size: 0.875rem;
  font-weight: 600;
  text-transform: uppercase;
  letter-spacing: 0.05em;
  margin-bottom: 0.5rem;
}

.stat-value {
  font-size: 2rem;
  font-weight: 700;
  line-height: 1;
  margin-bottom: 0;
}

.stat-badge {
  width: 56px;
  height: 56px;
  border-radius: 12px;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  font-size: 1.5rem;
  box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
  flex-shrink: 0;
}

.stat-icon-small {
  width: 40px;
  height: 40px;
  border-radius: 10px;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  font-size: 1rem;
}

.fade-in {
  animation: fadeIn 0.5s ease-out;
}

@keyframes fadeIn {
  from {
    opacity: 0;
    transform: translateY(10px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

.card {
  border: none;
  border-radius: 0.75rem;
  box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
  transition: all 0.3s ease;
  background: white;
}

.card:hover {
  box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
}

.card-header {
  background: #f9fafb;
  border-bottom: 1px solid #e5e7eb;
  padding: 1.25rem 1.5rem;
  font-weight: 600;
  border-radius: 0.75rem 0.75rem 0 0;
}

.card-body {
  padding: 1.5rem;
}

.shadow-md {
  box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
}

.table thead th {
  background: #f9fafb;
  border-bottom: 2px solid #e5e7eb;
  font-weight: 600;
  font-size: 0.875rem;
  text-transform: uppercase;
  letter-spacing: 0.05em;
  color: #374151;
  padding: 1rem;
}

.table tbody td {
  padding: 1rem;
  vertical-align: middle;
  border-bottom: 1px solid #e5e7eb;
}

.table tbody tr:hover {
  background-color: #f9fafb;
}

/* Bootstrap color variables */
:root {
  --bs-primary: #2563eb;
  --bs-success: #10b981;
  --bs-warning: #f59e0b;
  --bs-info: #06b6d4;
}
</style>
