<?php declare(strict_types=1); 
// Page-specific styles
$pageStyles = '
    .form-section {
      background: #f8f9fa;
      border-radius: 8px;
      padding: 1.5rem;
      margin-bottom: 1.5rem;
      border-left: 4px solid #0d6efd;
    }
    .section-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: #495057;
      margin-bottom: 1rem;
      padding-bottom: 0.5rem;
      border-bottom: 2px solid #dee2e6;
    }
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-primary text-white">
            <div class="d-flex justify-content-between align-items-center">
              <h2 class="h5 mb-0"><i class="fas fa-user-md me-2"></i>Add Doctor</h2>
              <a href="<?= htmlspecialchars($base) ?>/doctors" class="btn btn-light btn-sm">
                <i class="fas fa-list me-1"></i>View All Doctors
              </a>
            </div>
          </div>
          <div class="card-body p-4">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? $formError ?? null;
              $formErrors = $_SESSION['form_errors'] ?? $formErrors ?? [];
              $old = $_SESSION['old'] ?? $old ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>
            <?php endif; ?>
            
            <form method="post" action="<?= htmlspecialchars($base) ?>/doctors/store" id="doctorForm">
              <!-- Personal Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-user me-2"></i>Personal Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">First Name <span class="text-danger">*</span></label>
                    <input type="text" name="first_name" value="<?= htmlspecialchars($old['first_name'] ?? '') ?>" class="form-control form-control-lg" required />
                    <?php if (!empty($formErrors['first_name'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['first_name']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Last Name <span class="text-danger">*</span></label>
                    <input type="text" name="last_name" value="<?= htmlspecialchars($old['last_name'] ?? '') ?>" class="form-control form-control-lg" required />
                    <?php if (!empty($formErrors['last_name'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['last_name']) ?></div><?php endif; ?>
                  </div>
                </div>
              </div>

              <!-- Professional Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-stethoscope me-2"></i>Professional Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Specialty</label>
                    <input type="text" name="specialty" value="<?= htmlspecialchars($old['specialty'] ?? '') ?>" class="form-control form-control-lg" placeholder="e.g., Cardiology, Orthopedics, Pediatrics" />
                    <?php if (!empty($formErrors['specialty'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['specialty']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Department</label>
                    <select name="department_id" class="form-select form-select-lg">
                      <option value="">-- Select Department (Optional) --</option>
                      <?php foreach (($departments ?? []) as $dept): ?>
                        <option value="<?= (int)$dept['id'] ?>" <?= (isset($old['department_id']) && (int)$old['department_id'] === (int)$dept['id']) ? 'selected' : '' ?>>
                          <?= htmlspecialchars($dept['name']) ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                    <?php if (!empty($formErrors['department_id'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['department_id']) ?></div><?php endif; ?>
                  </div>
                </div>
              </div>

              <!-- Contact Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-address-book me-2"></i>Contact Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Phone</label>
                    <input type="tel" name="phone" value="<?= htmlspecialchars($old['phone'] ?? '') ?>" class="form-control form-control-lg" placeholder="+91 1234567890" />
                    <?php if (!empty($formErrors['phone'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['phone']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Email</label>
                    <input type="email" name="email" value="<?= htmlspecialchars($old['email'] ?? '') ?>" class="form-control form-control-lg" placeholder="doctor@hospital.com" />
                    <?php if (!empty($formErrors['email'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['email']) ?></div><?php endif; ?>
                  </div>
                </div>
              </div>

              <div class="d-flex justify-content-end gap-2 mt-4">
                <a class="btn btn-secondary btn-lg" href="<?= htmlspecialchars($base) ?>/doctors">
                  <i class="fas fa-times me-2"></i>Cancel
                </a>
                <button class="btn btn-primary btn-lg" type="submit">
                  <i class="fas fa-save me-2"></i>Add Doctor
                </button>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>
