<?php declare(strict_types=1);
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Doctor Attendance') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? null;
          $formError = $_SESSION['form_error'] ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
        ?>
        <?php if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>
        <?php if (!empty($formError)): ?>
          <div class="alert alert-danger alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3">
          <div>
            <h1 class="h4 mb-1"><i class="fas fa-user-check text-primary me-2"></i>Doctor Attendance</h1>
            <div class="text-muted small">Track daily attendance, timings and overtime</div>
          </div>
          <div class="mt-2 mt-md-0 d-flex gap-2">
            <button type="button" class="btn btn-primary shadow-sm" data-bs-toggle="modal" data-bs-target="#addAttendanceModal">
              <i class="fas fa-plus-circle me-2"></i>Add Attendance
            </button>
          </div>
        </div>

        <div class="card border-0 shadow-sm mb-3">
          <div class="card-body">
            <form class="row g-2" method="get" action="<?= htmlspecialchars($base) ?>/doctors/attendance">
              <div class="col-12 col-md-3">
                <label class="form-label small text-muted">Doctor</label>
                <select name="doctor_id" class="form-select form-select-sm">
                  <option value="">All Doctors</option>
                  <?php foreach (($doctors ?? []) as $doc): ?>
                    <option value="<?= (int)$doc['id'] ?>" <?= (!empty($selectedDoctor) && (int)$selectedDoctor === (int)$doc['id']) ? 'selected' : '' ?>>
                      <?= htmlspecialchars(($doc['first_name'] ?? '') . ' ' . ($doc['last_name'] ?? '') . (!empty($doc['specialty']) ? ' (' . $doc['specialty'] . ')' : '')) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-6 col-md-2">
                <label class="form-label small text-muted">From</label>
                <input type="date" name="date_from" value="<?= htmlspecialchars($dateFrom ?? '') ?>" class="form-control form-control-sm" />
              </div>
              <div class="col-6 col-md-2">
                <label class="form-label small text-muted">To</label>
                <input type="date" name="date_to" value="<?= htmlspecialchars($dateTo ?? '') ?>" class="form-control form-control-sm" />
              </div>
              <div class="col-12 col-md-3 d-flex align-items-end">
                <button class="btn btn-outline-secondary btn-sm me-2" type="submit"><i class="fas fa-filter me-1"></i>Apply</button>
                <a class="btn btn-link btn-sm" href="<?= htmlspecialchars($base) ?>/doctors/attendance">Reset</a>
              </div>
            </form>
          </div>
        </div>

        <div class="card border-0 shadow-sm">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Doctor</th>
                    <th>Status</th>
                    <th>Check-in</th>
                    <th>Check-out</th>
                    <th>Overtime</th>
                    <th>Remarks</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($items)): ?>
                    <?php foreach ($items as $idx => $row): ?>
                      <tr>
                        <td><?= (int)$idx + 1 + ((int)($page ?? 1) - 1) * (int)($perPage ?? 20) ?></td>
                        <td><?= htmlspecialchars($row['att_date'] ?? '') ?></td>
                        <td><?= htmlspecialchars(trim(($row['first_name'] ?? '') . ' ' . ($row['last_name'] ?? ''))) ?></td>
                        <td>
                          <?php $st = strtolower((string)($row['status'] ?? '')); ?>
                          <span class="badge <?= $st === 'full day' ? 'bg-success' : ($st === 'half day' ? 'bg-warning text-dark' : 'bg-secondary') ?>">
                            <?= htmlspecialchars($row['status'] ?? '') ?>
                          </span>
                        </td>
                        <td><?= htmlspecialchars($row['check_in'] ?? '—') ?></td>
                        <td><?= htmlspecialchars($row['check_out'] ?? '—') ?></td>
                        <td><?= (int)($row['overtime_minutes'] ?? 0) ?> mins</td>
                        <td class="text-muted small"><?= htmlspecialchars($row['remarks'] ?? '') ?></td>
                        <td class="text-end">
                          <form method="post" action="<?= htmlspecialchars($base) ?>/doctors/attendance/delete" onsubmit="return confirm('Delete this record?');">
                            <input type="hidden" name="id" value="<?= (int)($row['id'] ?? 0) ?>" />
                            <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                          </form>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="9" class="text-center text-muted py-4">No attendance records found.</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
          <?php if (($total ?? 0) > ($perPage ?? 20)): ?>
          <div class="card-footer d-flex justify-content-between align-items-center">
            <div class="text-muted">Total: <?= (int)$total ?></div>
            <nav>
              <?php
                $totalPages = (int)ceil(max(1, (int)$total) / max(1, (int)$perPage));
                $current = max(1, (int)$page);
                $prev = max(1, $current - 1);
                $next = min($totalPages, $current + 1);
              ?>
              <ul class="pagination mb-0">
                <li class="page-item <?= $current <= 1 ? 'disabled' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/doctors/attendance?page=<?= $prev ?>">Previous</a>
                </li>
                <li class="page-item disabled"><span class="page-link">Page <?= $current ?> of <?= $totalPages ?></span></li>
                <li class="page-item <?= $current >= $totalPages ? 'disabled' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/doctors/attendance?page=<?= $next ?>">Next</a>
                </li>
              </ul>
            </nav>
          </div>
          <?php endif; ?>
        </div>
      </main>
    </div>
  </div>

  <!-- Add Attendance Modal -->
  <div class="modal fade" id="addAttendanceModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title"><i class="fas fa-plus-circle me-2"></i>Add Attendance</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="<?= htmlspecialchars($base) ?>/doctors/attendance/store">
          <div class="modal-body">
            <div class="mb-3">
              <label class="form-label fw-semibold">Doctor <span class="text-danger">*</span></label>
              <select name="doctor_id" class="form-select form-select-lg" required>
                <option value="">-- Select Doctor --</option>
                <?php foreach (($doctors ?? []) as $doc): ?>
                  <option value="<?= (int)$doc['id'] ?>" <?= (!empty($selectedDoctor) && (int)$selectedDoctor === (int)$doc['id']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars(($doc['first_name'] ?? '') . ' ' . ($doc['last_name'] ?? '') . (!empty($doc['specialty']) ? ' (' . $doc['specialty'] . ')' : '')) ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>

            <div class="row">
              <div class="col-12 mb-2">
                <label class="form-label fw-semibold d-block">Preset</label>
                <div class="btn-group" role="group">
                  <button type="button" class="btn btn-outline-primary btn-preset" data-preset="present"><i class="fas fa-user-check me-1"></i>Present</button>
                  <button type="button" class="btn btn-outline-secondary btn-preset" data-preset="absent"><i class="fas fa-user-xmark me-1"></i>Absent</button>
                  <button type="button" class="btn btn-outline-info btn-preset" data-preset="leave"><i class="fas fa-plane-departure me-1"></i>Leave</button>
                </div>
                <small class="text-muted d-block mt-1">Use presets to quickly set status and time fields.</small>
              </div>
              <div class="col-6 mb-3">
                <label class="form-label fw-semibold">Date <span class="text-danger">*</span></label>
                <input type="date" name="att_date" class="form-control" value="<?= htmlspecialchars(date('Y-m-d')) ?>" required />
                <small class="text-muted">Attendance will be recorded for this date.</small>
              </div>
              <div class="col-6 mb-3">
                <label class="form-label fw-semibold d-block">Status</label>
                <div class="btn-group w-100" role="group">
                  <input type="radio" class="btn-check" name="status" id="status_full" value="Full Day" autocomplete="off" checked>
                  <label class="btn btn-outline-success" for="status_full"><i class="fas fa-circle-check me-1"></i>Full Day</label>
                  <input type="radio" class="btn-check" name="status" id="status_half" value="Half Day" autocomplete="off">
                  <label class="btn btn-outline-warning" for="status_half"><i class="fas fa-adjust me-1"></i>Half Day</label>
                  <input type="radio" class="btn-check" name="status" id="status_absent" value="Absent" autocomplete="off">
                  <label class="btn btn-outline-secondary" for="status_absent"><i class="fas fa-xmark me-1"></i>Absent</label>
                  <input type="radio" class="btn-check" name="status" id="status_leave" value="Leave" autocomplete="off">
                  <label class="btn btn-outline-info" for="status_leave"><i class="fas fa-plane me-1"></i>Leave</label>
                </div>
                <small class="text-muted d-block mt-1">Full Day ≈ 8 hours, Half Day ≈ 4 hours. Absent/Leave disables time fields.</small>
              </div>
            </div>

            <div class="row">
              <div class="col-6 mb-3">
                <label class="form-label fw-semibold">Check-in</label>
                <div class="input-group">
                  <span class="input-group-text"><i class="fas fa-clock"></i></span>
                  <input type="time" name="check_in" id="att_check_in" class="form-control" />
                  <button class="btn btn-outline-secondary btn-time" type="button" data-time="09:00">09:00</button>
                </div>
                <small class="text-muted">Optional. Use if tracking exact times.</small>
              </div>
              <div class="col-6 mb-3">
                <label class="form-label fw-semibold">Check-out</label>
                <div class="input-group">
                  <span class="input-group-text"><i class="fas fa-clock"></i></span>
                  <input type="time" name="check_out" id="att_check_out" class="form-control" />
                  <button class="btn btn-outline-secondary btn-time" type="button" data-time="17:00">17:00</button>
                  <button class="btn btn-outline-secondary btn-time" type="button" data-time="now">Now</button>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-6 mb-3">
                <label class="form-label fw-semibold">Overtime (mins)</label>
                <div class="input-group">
                  <button class="btn btn-outline-secondary btn-ot" type="button" data-add="15">+15</button>
                  <button class="btn btn-outline-secondary btn-ot" type="button" data-add="30">+30</button>
                  <button class="btn btn-outline-secondary btn-ot" type="button" data-add="60">+60</button>
                  <input type="number" name="overtime_minutes" id="att_ot" min="0" value="0" class="form-control text-end" />
                </div>
              </div>
              <div class="col-6 mb-3">
                <label class="form-label fw-semibold">Remarks</label>
                <input type="text" name="remarks" class="form-control" placeholder="Optional" />
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Save</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Helpers
    function minutesBetween(start, end){
      if(!start || !end) return 0;
      const [sh, sm] = start.split(':').map(Number);
      const [eh, em] = end.split(':').map(Number);
      let s = sh*60 + sm, e = eh*60 + em;
      if (e < s) e += 24*60; // cross midnight
      return Math.max(0, e - s);
    }

    function baseMinutes(){
      const full = document.getElementById('status_full');
      const half = document.getElementById('status_half');
      if (half && half.checked) return 240; // 4h
      if (full && full.checked) return 480; // 8h
      return 0;
    }

    function recalcOvertime(){
      const statusAbsent = document.getElementById('status_absent');
      const statusLeave = document.getElementById('status_leave');
      const inEl = document.getElementById('att_check_in');
      const outEl = document.getElementById('att_check_out');
      const otEl = document.getElementById('att_ot');
      const disableTimes = (statusAbsent && statusAbsent.checked) || (statusLeave && statusLeave.checked);
      inEl.disabled = disableTimes;
      outEl.disabled = disableTimes;
      otEl.disabled = false;
      if (disableTimes){ otEl.value = 0; otEl.disabled = true; return; }
      const worked = minutesBetween(inEl.value, outEl.value);
      // Auto set status based on worked
      if (worked > 0){
        const statusFull = document.getElementById('status_full');
        const statusHalf = document.getElementById('status_half');
        if (worked >= 480) { statusFull.checked = true; }
        else { statusHalf.checked = true; }
      }
      const base = baseMinutes();
      if (base > 0 && worked > 0){ otEl.value = Math.max(0, worked - base); }
    }

    function applyPreset(preset){
      const inEl = document.getElementById('att_check_in');
      const outEl = document.getElementById('att_check_out');
      const otEl = document.getElementById('att_ot');
      const statusFull = document.getElementById('status_full');
      const statusAbsent = document.getElementById('status_absent');
      const statusLeave = document.getElementById('status_leave');
      if (preset === 'present'){
        statusFull.checked = true;
        inEl.disabled = false; outEl.disabled = false; otEl.disabled = false;
        if (!inEl.value) inEl.value = '09:00';
      } else if (preset === 'absent'){
        statusAbsent.checked = true;
        inEl.value = ''; outEl.value = ''; otEl.value = 0;
        inEl.disabled = true; outEl.disabled = true; otEl.disabled = true;
      } else if (preset === 'leave'){
        statusLeave.checked = true;
        inEl.value = ''; outEl.value = ''; otEl.value = 0;
        inEl.disabled = true; outEl.disabled = true; otEl.disabled = true;
      }
    }

    document.addEventListener('click', function(e){
      // Quick add buttons for overtime
      const btnOt = e.target.closest('.btn-ot');
      if(btnOt){
        const input = document.getElementById('att_ot');
        const add = parseInt(btnOt.getAttribute('data-add') || '0', 10);
        const cur = parseInt(input.value || '0', 10);
        input.value = Math.max(0, cur + add);
        return;
      }
      // Quick set time buttons
      const btnTime = e.target.closest('.btn-time');
      if(btnTime){
        let time = btnTime.getAttribute('data-time');
        if (time === 'now'){
          const now = new Date();
          const hh = String(now.getHours()).padStart(2,'0');
          const mm = String(now.getMinutes()).padStart(2,'0');
          time = `${hh}:${mm}`;
        }
        const group = btnTime.closest('.input-group');
        const input = group ? group.querySelector('input[type="time"]') : null;
        if(input){ input.value = time; recalcOvertime(); }
        return;
      }
      // Presets
      const btnPreset = e.target.closest('.btn-preset');
      if(btnPreset){
        const preset = btnPreset.getAttribute('data-preset');
        applyPreset(preset);
        return;
      }
    });

    document.addEventListener('change', function(e){
      const id = e.target.id;
      if (id === 'att_check_in' || id === 'att_check_out' || id === 'status_full' || id === 'status_half' || id === 'status_absent' || id === 'status_leave'){
        recalcOvertime();
      }
    });

    // Initialize on modal show
    document.getElementById('addAttendanceModal')?.addEventListener('shown.bs.modal', function(){
      recalcOvertime();
    });
  </script>
</body>
</html>
