<?php declare(strict_types=1);
// Page-specific styles
$pageStyles = '
    .filter-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 12px;
    }
    .doctor-card {
      transition: transform 0.2s, box-shadow 0.2s;
    }
    .doctor-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? $flashSuccess ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Header Section -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-user-md text-primary me-2"></i>Doctors</h1>
            <p class="text-muted mb-0">Manage doctors and their schedules</p>
          </div>
          <div class="mt-3 mt-md-0">
            <a href="<?= htmlspecialchars($base) ?>/doctors/add" class="btn btn-primary btn-lg shadow-sm me-2">
              <i class="fas fa-plus-circle me-2"></i>Add Doctor
            </a>
            <a href="<?= htmlspecialchars($base) ?>/doctors/schedule" class="btn btn-success btn-lg shadow-sm">
              <i class="fas fa-calendar-alt me-2"></i>Doctor Schedule
            </a>
          </div>
        </div>

        <!-- Filter Card -->
        <div class="card filter-card shadow-sm mb-4 border-0">
          <div class="card-body p-4">
            <form method="get" action="<?= htmlspecialchars($base) ?>/doctors" class="row g-3">
              <div class="col-md-4">
                <label class="form-label text-white fw-semibold"><i class="fas fa-search me-2"></i>Search</label>
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Name, specialty, phone, email..." class="form-control form-control-lg" />
              </div>
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-building me-2"></i>Department</label>
                <select name="department" class="form-select form-select-lg">
                  <option value="">All Departments</option>
                  <?php foreach (($departments ?? []) as $dept): ?>
                    <option value="<?= (int)$dept['id'] ?>" <?= (isset($department) && (int)$department === (int)$dept['id']) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($dept['name']) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-light btn-lg w-100 shadow-sm" type="submit">
                  <i class="fas fa-filter me-2"></i>Filter
                </button>
              </div>
              <div class="col-md-3 d-flex align-items-end">
                <a href="<?= htmlspecialchars($base) ?>/doctors" class="btn btn-outline-light btn-lg w-100 shadow-sm">
                  <i class="fas fa-redo me-2"></i>Reset
                </a>
              </div>
            </form>
          </div>
        </div>

        <!-- Doctors List Table -->
        <div class="card shadow-sm border-0">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Doctor Name</th>
                    <th scope="col">Specialty</th>
                    <th scope="col">Department</th>
                    <th scope="col">Contact</th>
                    <th scope="col">Added On</th>
                    <th scope="col">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($doctors)): ?>
                    <?php foreach ($doctors as $doc): ?>
                      <tr>
                        <td><strong>DR<?= str_pad((string)$doc['id'], 3, '0', STR_PAD_LEFT) ?></strong></td>
                        <td>
                          <div class="fw-semibold"><?= htmlspecialchars($doc['first_name'] . ' ' . $doc['last_name']) ?></div>
                        </td>
                        <td>
                          <?php if (!empty($doc['specialty'])): ?>
                            <span class="badge bg-info"><?= htmlspecialchars($doc['specialty']) ?></span>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if (!empty($doc['department_name'])): ?>
                            <?= htmlspecialchars($doc['department_name']) ?>
                          <?php else: ?>
                            <span class="text-muted">Not Assigned</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <div class="small">
                            <?php if (!empty($doc['phone'])): ?>
                              <div><i class="fas fa-phone me-1"></i><?= htmlspecialchars($doc['phone']) ?></div>
                            <?php endif; ?>
                            <?php if (!empty($doc['email'])): ?>
                              <div><i class="fas fa-envelope me-1"></i><?= htmlspecialchars($doc['email']) ?></div>
                            <?php endif; ?>
                            <?php if (empty($doc['phone']) && empty($doc['email'])): ?>
                              <span class="text-muted">-</span>
                            <?php endif; ?>
                          </div>
                        </td>
                        <td><?= date('d-M-Y', strtotime($doc['created_at'])) ?></td>
                        <td>
                          <a href="<?= htmlspecialchars($base) ?>/doctors/view?id=<?= urlencode((string)$doc['id']) ?>" class="btn btn-sm btn-outline-info me-1" title="View Details">
                            <i class="fas fa-eye"></i>
                          </a>
                          <a href="<?= htmlspecialchars($base) ?>/doctors/schedule?doctor_id=<?= urlencode((string)$doc['id']) ?>" class="btn btn-sm btn-outline-success" title="View Schedule">
                            <i class="fas fa-calendar"></i>
                          </a>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="7" class="text-center text-muted py-4">No doctors found.</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <!-- Pagination -->
        <?php if (($total ?? 0) > ($perPage ?? 20)): ?>
          <nav aria-label="Page navigation" class="mt-4">
            <ul class="pagination justify-content-center">
              <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                <a class="page-link" href="<?= htmlspecialchars($base) ?>/doctors?<?= http_build_query(array_merge($_GET, ['page' => $page - 1])) ?>" aria-label="Previous">
                  <span aria-hidden="true">&laquo;</span>
                </a>
              </li>
              <?php for ($i = 1; $i <= ceil($total / $perPage); $i++): ?>
                <li class="page-item <?= ($page === $i) ? 'active' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/doctors?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>"><?= $i ?></a>
                </li>
              <?php endfor; ?>
              <li class="page-item <?= ($page >= ceil($total / $perPage)) ? 'disabled' : '' ?>">
                <a class="page-link" href="<?= htmlspecialchars($base) ?>/doctors?<?= http_build_query(array_merge($_GET, ['page' => $page + 1])) ?>" aria-label="Next">
                  <span aria-hidden="true">&raquo;</span>
                </a>
              </li>
            </ul>
          </nav>
        <?php endif; ?>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>
