<?php declare(strict_types=1); 
// Page-specific styles
$pageStyles = '
    .schedule-card {
      border-left: 4px solid #0d6efd;
      transition: transform 0.2s;
    }
    .schedule-card:hover {
      transform: translateX(5px);
    }
    .day-badge {
      font-size: 0.85rem;
      padding: 0.4rem 0.8rem;
    }
    .time-slot {
      background: #f8f9fa;
      border-radius: 6px;
      padding: 0.5rem;
      margin: 0.25rem 0;
    }
';

// Page-specific scripts
$pageScripts = '
    document.addEventListener("DOMContentLoaded", function() {
      const doctorSelect = document.getElementById("doctor_id");
      const urlParams = new URLSearchParams(window.location.search);
      const doctorId = urlParams.get("doctor_id");
      if (doctorId && doctorSelect) {
        doctorSelect.value = doctorId;
      }
    });
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          // MVC Pattern: View uses data passed from Controller, no direct session access
          if (!empty($flashSuccess ?? null)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>
        <?php if (!empty($formError ?? null)): ?>
          <div class="alert alert-danger alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Header Section -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-calendar-alt text-primary me-2"></i>Doctor Schedule</h1>
            <p class="text-muted mb-1">Manage doctor availability and schedules</p>
            <!-- Filter: View schedules for all or a specific doctor -->
            <form class="row g-2" method="get" action="<?= htmlspecialchars($base) ?>/doctors/schedule">
              <div class="col-auto">
                <select name="doctor_id" class="form-select form-select-sm">
                  <option value="">All Doctors</option>
                  <?php foreach (($doctors ?? []) as $doc): ?>
                    <option value="<?= (int)$doc['id'] ?>" <?= (!empty($selectedDoctor) && (int)$selectedDoctor === (int)$doc['id']) ? 'selected' : '' ?>>
                      <?= htmlspecialchars($doc['first_name'] . ' ' . $doc['last_name'] . ' (' . ($doc['specialty'] ?? 'N/A') . ')') ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-auto">
                <button type="submit" class="btn btn-outline-secondary btn-sm"><i class="fas fa-filter me-1"></i>Apply</button>
                <a href="<?= htmlspecialchars($base) ?>/doctors/schedule" class="btn btn-link btn-sm">Reset</a>
              </div>
            </form>
          </div>
          <div class="mt-3 mt-md-0 d-flex gap-2">
            <button type="button" class="btn btn-primary btn-lg shadow-sm" data-bs-toggle="modal" data-bs-target="#addScheduleModal">
              <i class="fas fa-plus-circle me-2"></i>Add Schedule
            </button>
            <a href="<?= htmlspecialchars($base) ?>/doctors/schedule/calendar<?= !empty($selectedDoctor) ? ('?doctor_id='.(int)$selectedDoctor) : '' ?>" class="btn btn-outline-primary btn-lg shadow-sm">
              <i class="fas fa-calendar-week me-2"></i>Calendar View
            </a>
            <a href="<?= htmlspecialchars($base) ?>/doctors" class="btn btn-secondary btn-lg shadow-sm">
              <i class="fas fa-arrow-left me-2"></i>Back to Doctors
            </a>
          </div>
        </div>

        <div class="row">
          <!-- Schedule List: full width -->
          <div class="col-12">
            <div class="card shadow-sm border-0">
              <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fas fa-calendar-check me-2"></i>Schedule List</h5>
              </div>
              <div class="card-body">
                <?php if (!empty($schedules)): ?>
                  <div class="row g-3">
                    <?php
                      $groupedSchedules = [];
                      foreach ($schedules as $schedule) {
                        $doctorName = $schedule['first_name'] . ' ' . $schedule['last_name'];
                        if (!isset($groupedSchedules[$doctorName])) {
                          $groupedSchedules[$doctorName] = [];
                        }
                        $groupedSchedules[$doctorName][] = $schedule;
                      }
                      foreach ($groupedSchedules as $doctorName => $doctorSchedules):
                    ?>
                      <div class="col-12">
                        <div class="card schedule-card shadow-sm border-0 mb-3">
                          <div class="card-header bg-light">
                            <div class="d-flex justify-content-between align-items-center">
                              <h6 class="mb-0">
                                <i class="fas fa-user-md me-2"></i>
                                <strong><?= htmlspecialchars($doctorName) ?></strong>
                                <?php if (!empty($doctorSchedules[0]['specialty'])): ?>
                                  <span class="badge bg-info ms-2"><?= htmlspecialchars($doctorSchedules[0]['specialty']) ?></span>
                                <?php endif; ?>
                              </h6>
                            </div>
                          </div>
                          <div class="card-body">
                            <div class="row g-2">
                              <?php foreach ($doctorSchedules as $schedule): ?>
                                <div class="col-md-6">
                                  <div class="time-slot">
                                    <div class="d-flex justify-content-between align-items-center">
                                      <div>
                                        <span class="badge day-badge bg-primary"><?= htmlspecialchars($schedule['day_of_week']) ?></span>
                                        <span class="ms-2">
                                          <?= date('h:i A', strtotime($schedule['start_time'])) ?> - <?= date('h:i A', strtotime($schedule['end_time'])) ?>
                                        </span>
                                        <?php if (!$schedule['is_available']): ?>
                                          <span class="badge bg-danger ms-2">Unavailable</span>
                                        <?php endif; ?>
                                      </div>
                                      <form method="post" action="<?= htmlspecialchars($base) ?>/doctors/schedule/delete" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this schedule?');">
                                        <input type="hidden" name="id" value="<?= (int)$schedule['id'] ?>" />
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                          <i class="fas fa-trash"></i>
                                        </button>
                                      </form>
                                    </div>
                                  </div>
                                </div>
                              <?php endforeach; ?>
                            </div>
                          </div>
                        </div>
                      </div>
                    <?php endforeach; ?>
                  </div>
                <?php else: ?>
                  <div class="text-center text-muted py-5">
                    <i class="fas fa-calendar-times fa-3x mb-3"></i>
                    <p>No schedules found. Click "Add Schedule" to create one.</p>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>

        <!-- Add Schedule Modal -->
        <div class="modal fade" id="addScheduleModal" tabindex="-1" aria-labelledby="addScheduleLabel" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="addScheduleLabel"><i class="fas fa-plus-circle me-2"></i>Add Schedule</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <form method="post" action="<?= htmlspecialchars($base) ?>/doctors/schedule/store">
                <div class="modal-body">
                  <div class="mb-3">
                    <label class="form-label fw-semibold">Doctor <span class="text-danger">*</span></label>
                    <select name="doctor_id" id="modal_doctor_id" class="form-select" required>
                      <option value="">-- Select Doctor --</option>
                      <?php foreach (($doctors ?? []) as $doc): ?>
                        <option value="<?= (int)$doc['id'] ?>" <?= (isset($selectedDoctor) && (int)$selectedDoctor === (int)$doc['id']) ? 'selected' : '' ?>>
                          <?= htmlspecialchars($doc['first_name'] . ' ' . $doc['last_name'] . ' (' . ($doc['specialty'] ?? 'N/A') . ')') ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                  </div>
                  <div class="mb-3">
                    <label class="form-label fw-semibold">Day of Week <span class="text-danger">*</span></label>
                    <select name="day_of_week" class="form-select" required>
                      <option value="">-- Select Day --</option>
                      <option value="Monday">Monday</option>
                      <option value="Tuesday">Tuesday</option>
                      <option value="Wednesday">Wednesday</option>
                      <option value="Thursday">Thursday</option>
                      <option value="Friday">Friday</option>
                      <option value="Saturday">Saturday</option>
                      <option value="Sunday">Sunday</option>
                    </select>
                  </div>
                  <div class="row">
                    <div class="col-6 mb-3">
                      <label class="form-label fw-semibold">Start Time <span class="text-danger">*</span></label>
                      <input type="time" name="start_time" class="form-control" required />
                    </div>
                    <div class="col-6 mb-3">
                      <label class="form-label fw-semibold">End Time <span class="text-danger">*</span></label>
                      <input type="time" name="end_time" class="form-control" required />
                    </div>
                  </div>
                  <div class="form-check mb-1">
                    <input class="form-check-input" type="checkbox" name="is_available" id="modal_is_available" value="1" checked>
                    <label class="form-check-label" for="modal_is_available">Available</label>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                  <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Save Schedule</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>






