<?php declare(strict_types=1);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Doctor Schedule Calendar') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
  <style>
    #calendar { min-height: 720px; background: #fff; border-radius: .75rem; padding: .5rem; }
    .fc .fc-toolbar-title { font-size: 1.15rem; }
    .legend-badge { width: 10px; height: 10px; display: inline-block; border-radius: 2px; margin-right: 6px; }
  </style>
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3">
          <div>
            <h1 class="h4 mb-1"><i class="fas fa-calendar-week text-primary me-2"></i>Doctor Schedule Calendar</h1>
            <div class="text-muted small">View weekly availability of all doctors</div>
          </div>
          <div class="mt-2 mt-md-0 d-flex gap-2">
            <form class="d-flex" method="get" action="<?= htmlspecialchars($base) ?>/doctors/schedule/calendar">
              <select name="doctor_id" class="form-select form-select-sm me-2">
                <option value="">All Doctors</option>
                <?php foreach (($doctors ?? []) as $doc): ?>
                  <option value="<?= (int)$doc['id'] ?>" <?= (!empty($selectedDoctor) && (int)$selectedDoctor === (int)$doc['id']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars(($doc['first_name'] ?? '') . ' ' . ($doc['last_name'] ?? '') . (!empty($doc['specialty']) ? ' (' . $doc['specialty'] . ')' : '')) ?>
                  </option>
                <?php endforeach; ?>
              </select>
              <button class="btn btn-outline-secondary btn-sm" type="submit"><i class="fas fa-filter me-1"></i>Apply</button>
            </form>
            <a href="<?= htmlspecialchars($base) ?>/doctors/schedule" class="btn btn-secondary btn-sm"><i class="fas fa-list me-1"></i>List View</a>
          </div>
        </div>

        <div class="card border-0 shadow-sm">
          <div class="card-body">
            <div id="calendar"></div>
          </div>
        </div>
      </main>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.js"></script>
  <script>
    (function(){
      // Map PHP schedules to FullCalendar weekly recurring events
      const raw = <?= json_encode($schedules ?? [], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>;
      const dayIndex = { 'Sunday':0,'Monday':1,'Tuesday':2,'Wednesday':3,'Thursday':4,'Friday':5,'Saturday':6 };
      const colors = ['#0d6efd','#198754','#6f42c1','#fd7e14','#20c997','#0dcaf0','#6610f2','#dc3545'];
      const nameColor = new Map();
      let colorPtr = 0;

      const events = (raw || []).map(function(s){
        const doctorName = ((s.first_name||'') + ' ' + (s.last_name||'')).trim();
        if (!nameColor.has(doctorName)) { nameColor.set(doctorName, colors[colorPtr % colors.length]); colorPtr++; }
        const color = nameColor.get(doctorName);
        return {
          title: doctorName + (s.specialty ? ' ('+s.specialty+')' : ''),
          daysOfWeek: [ dayIndex[s.day_of_week] ?? 1 ],
          startTime: s.start_time,
          endTime: s.end_time,
          display: 'block',
          backgroundColor: color + '33', // translucent fill
          borderColor: color,
          textColor: '#1f2937',
        };
      });

      const calendarEl = document.getElementById('calendar');
      if (!calendarEl) return;
      const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'timeGridWeek',
        nowIndicator: true,
        height: 'auto',
        slotMinTime: '06:00:00',
        slotMaxTime: '22:00:00',
        headerToolbar: {
          left: 'prev,next today',
          center: 'title',
          right: 'timeGridDay,timeGridWeek,dayGridMonth'
        },
        events: events,
      });
      calendar.render();
    })();
  </script>
</body>
</html>
