<?php declare(strict_types=1); 
// Body class for this page
$bodyClass = 'bg-light';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <div class="container py-4">
    <a href="/admin/doctors" class="btn btn-link">&larr; Back to Doctors</a>
    <div class="row justify-content-center mt-2">
      <div class="col-12 col-lg-8">
        <div class="card border-0 shadow-sm">
          <div class="card-body p-4">
            <h1 class="h4 mb-4">Doctor Details</h1>
            <div class="row g-3">
              <div class="col-md-6">
                <div class="text-secondary">First Name</div>
                <div class="fw-semibold"><?= htmlspecialchars($doctor['first_name'] ?? '') ?></div>
              </div>
              <div class="col-md-6">
                <div class="text-secondary">Last Name</div>
                <div class="fw-semibold"><?= htmlspecialchars($doctor['last_name'] ?? '') ?></div>
              </div>
              <div class="col-md-6">
                <div class="text-secondary">Specialty</div>
                <div class="fw-semibold"><?= htmlspecialchars($doctor['specialty'] ?? '') ?></div>
              </div>
              <div class="col-md-6">
                <div class="text-secondary">Department ID</div>
                <div class="fw-semibold"><?= htmlspecialchars((string)($doctor['department_id'] ?? '')) ?></div>
              </div>
              <div class="col-md-6">
                <div class="text-secondary">Phone</div>
                <div class="fw-semibold"><?= htmlspecialchars($doctor['phone'] ?? '') ?></div>
              </div>
              <div class="col-md-6">
                <div class="text-secondary">Email</div>
                <div class="fw-semibold"><?= htmlspecialchars($doctor['email'] ?? '') ?></div>
              </div>
              <div class="col-12">
                <div class="text-secondary">Created</div>
                <div class="fw-semibold"><?= htmlspecialchars($doctor['created_at'] ?? '') ?></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php 
// Include footer
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php';
?>
