<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <title><?= htmlspecialchars($title ?? 'HMS Admin') ?></title>
  
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Admin Custom CSS -->
  <link href="<?= htmlspecialchars($base ?? '') ?>/public/assets/css/admin.css" rel="stylesheet">
  
  <!-- Sidebar CSS -->
  <link href="<?= htmlspecialchars($base ?? '') ?>/public/assets/css/sidebar.css" rel="stylesheet">
  
  <!-- Page-specific styles (if any) -->
  <?php if (isset($pageStyles) && !empty($pageStyles)): ?>
    <style><?= $pageStyles ?></style>
  <?php endif; ?>
</head>
<body<?= !empty($bodyClass ?? '') ? ' class="' . htmlspecialchars($bodyClass) . '"' : '' ?>>

