<?php declare(strict_types=1); 
// Hospital name is now passed from Controller via view() method
// Fallback to default if not set
$hospitalName = $hospitalName ?? 'Hospital Management System';
$role = $role ?? (class_exists('Auth') ? (Auth::user()['role'] ?? 'Admin') : 'Admin');
?>
<nav class="topbar fixed-top" style="z-index:1030;">
  <div class="topbar-inner container-fluid position-relative">
    <div class="topbar-left d-flex align-items-center gap-2">
      <button class="btn btn-ghost d-lg-none" id="toggleSidebar" type="button" aria-label="Toggle sidebar">☰</button>
      <a class="brand d-flex align-items-center" href="<?= htmlspecialchars($base ?? '') ?>/">
        <img src="<?= htmlspecialchars($base ?? '') ?>/public/assets/images/logo.png" alt="logo" onerror="this.style.display='none'"/>
        <span class="brand-title">HMS Admin</span>
      </a>
    </div>

    <div class="topbar-center position-absolute start-50 translate-middle-x d-flex align-items-center justify-content-center text-center">
      <div class="hospital-name"><?= htmlspecialchars($hospitalName) ?></div>
    </div>

    <div class="topbar-right ms-auto d-flex align-items-center gap-2">
      <div class="d-none d-md-block text-muted small me-2"><?= htmlspecialchars($role) ?></div>
      <a class="btn btn-outline-light btn-sm" href="<?= htmlspecialchars($base ?? '') ?>/logout">Logout</a>
    </div>
  </div>
</nav>

<!-- Secondary small sub-navbar with quick module shortcuts -->
<nav class="subnav fixed-top">
  <div class="subnav-inner container-fluid">
    <div class="subnav-left d-flex align-items-center justify-content-center w-100">
      <!-- Shortcut buttons with text labels centered -->
      <button class="btn btn-sub" data-target="Dashboard">Dashboard</button>
      <button class="btn btn-sub" data-target="Patients">Patients</button>
      <button class="btn btn-sub" data-target="Doctors">Doctors</button>
      <button class="btn btn-sub" data-target="Appointments">Appointments</button>
      <button class="btn btn-sub" data-target="Billing">Billing</button>
      <button class="btn btn-sub" data-target="Laboratory">Laboratory</button>
      <button class="btn btn-sub" data-target="Pharmacy">Pharmacy</button>
    </div>
  </div>
</nav>

<script>
// Subnav shortcut behavior: find sidebar item by label text and trigger click.
(function(){
  function findSidebarByLabel(text){
    var labels = document.querySelectorAll('#sidebar .nav-item .label');
    text = text.trim().toLowerCase();
    for(var i=0;i<labels.length;i++){
      var el = labels[i];
      if(el.textContent.trim().toLowerCase() === text){
        return el.closest('.nav-item');
      }
    }
    return null;
  }

  document.addEventListener('click', function(e){
    var btn = e.target.closest('.subnav .btn-sub');
    if(!btn) return;
    var target = btn.getAttribute('data-target');
    if(!target) return;
    var item = findSidebarByLabel(target);
    if(item){
      // if item is inside a collapsed section, open it
      var section = item.closest('.nav-section');
      if(section && section.classList && !section.classList.contains('open')){
        var collapser = section.querySelector('.js-collapser');
        if(collapser) collapser.click();
      }
      // trigger link or click
      var link = item.closest('a') || item.querySelector('a');
      if(link){
        window.location = link.getAttribute('href');
      } else {
        item.click();
      }
    }
  });
})();
</script>
