<?php
// determine current path for active menu highlighting
$currentPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH) ?: '/';
function is_active($path, $current) {
    // exact or starts-with match
    if ($path === '/') return $current === '/';
    return strpos($current, $path) === 0 ? 'active' : '';
}
function section_open($paths, $current) {
    foreach ($paths as $p) {
        if ($p === '/') { if ($current === '/') return 'open'; }
        if (strpos($current, $p) === 0) return 'open';
    }
    return '';
}
?><aside class="sidebar p-0 m-0 fixed-left" id="sidebar">
    <div class="sidebar-header">
        <img src="https://www.vidyapranali.com/assets/images/mpp_logo.jpg?v=1" alt="Logo">


        <div class="sidebar-title">Hospital ERP</div>
        <form class="sidebar-search mt-2" role="search" action="<?= htmlspecialchars($base) ?>/search" method="get">
            <input name="q" class="form-control form-control-sm" type="search" placeholder="Search patients, doctors..." aria-label="Search">
            <button class="btn btn-sm btn-primary mt-2" type="submit">Search</button>
        </form>
    </div>
    <nav class="nav">
        <div class="nav-section">
            <div class="section-title">Main</div>
            <a href="<?= htmlspecialchars($base) ?>/" class="nav-item <?= is_active('/', $currentPath) ?>">
                <span class="icon">🏥</span>
                <span class="label">Dashboard</span>
            </a>
        </div>

        <div class="nav-section">
            <div class="section-title">Master Setup</div>
            <div class="nav-item js-collapser <?= section_open(['/master','/departments','/services','/servicecs','/charges','/rooms','/beds','/staff','/user_roles'], $currentPath) ?>"><a href="#" class="icon">🧭</a><span class="label">Master Setup</span>
            </div>
            <div class="nav-collapse <?= section_open(['/master','/departments','/services','/servicecs','/charges','/rooms','/beds','/staff','/user_roles'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/departments" class="nav-item <?= is_active('/departments', $currentPath) ?>"><span class="icon">🏢</span><span class="label">Departments</span></a>
                <a href="<?= htmlspecialchars($base) ?>/services" class="nav-item <?= is_active('/services', $currentPath) ?> <?= is_active('/servicecs', $currentPath) ?>"><span class="icon">🛠️</span><span class="label">Services</span></a>
                <a href="<?= htmlspecialchars($base) ?>/charges" class="nav-item <?= is_active('/charges', $currentPath) ?>"><span class="icon">💲</span><span class="label">Charges</span></a>
                <a href="<?= htmlspecialchars($base) ?>/rooms" class="nav-item <?= is_active('/rooms', $currentPath) ?>"><span class="icon">🏨</span><span class="label">Rooms / Wards</span></a>
                <a href="<?= htmlspecialchars($base) ?>/beds" class="nav-item <?= is_active('/beds', $currentPath) ?>"><span class="icon">🛏️</span><span class="label">Bed Allocation</span></a>
                <a href="<?= htmlspecialchars($base) ?>/staff" class="nav-item <?= is_active('/staff', $currentPath) ?>"><span class="icon">👥</span><span class="label">Staff Management</span></a>
                <a href="<?= htmlspecialchars($base) ?>/user_roles" class="nav-item <?= is_active('/user_roles', $currentPath) ?>"><span class="icon">🔐</span><span class="label">User Roles</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Patient Management</div>
            <div class="nav-item js-collapser <?= section_open(['/patients','/opd','/ipd','/admissions','/beds'], $currentPath) ?>"><a href="#" class="icon">🧑‍⚕️</a><span class="label">Patients</span>
            </div>
            <div class="nav-collapse <?= section_open(['/patients','/opd','/ipd','/admissions','/beds'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/patients/add" class="nav-item <?= is_active('/patients/add', $currentPath) ?>"><span class="icon">➕</span><span class="label">Add Patient</span></a>
                <a href="<?= htmlspecialchars($base) ?>/patients" class="nav-item <?= is_active('/patients', $currentPath) ?>"><span class="icon">📋</span><span class="label">Patient List</span></a>
                <a href="<?= htmlspecialchars($base) ?>/opd/registration" class="nav-item <?= is_active('/opd', $currentPath) ?>"><span class="icon">🏥</span><span class="label">OPD Registration</span></a>
                <a href="<?= htmlspecialchars($base) ?>/admissions" class="nav-item <?= is_active('/admissions', $currentPath) ?>"><span class="icon">🏥</span><span class="label">IPD Admission</span></a>
                <a href="<?= htmlspecialchars($base) ?>/beds" class="nav-item <?= is_active('/beds', $currentPath) ?>"><span class="icon">🛏️</span><span class="label">Room Allocation</span></a>
                <a href="<?= htmlspecialchars($base) ?>/patients/discharged" class="nav-item <?= is_active('/patients/discharged', $currentPath) ?>"><span class="icon">✅</span><span class="label">Discharged Patients</span></a>
                <a href="#" class="nav-item"><span class="icon">🗑️</span><span class="label">Deleted Patients</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Doctor Management</div>
            <div class="nav-item js-collapser <?= section_open(['/doctors','/schedules','/attendance'], $currentPath) ?>"><a href="#" class="icon">👨‍⚕️</a><span class="label">Doctors</span>
            </div>
            <div class="nav-collapse <?= section_open(['/doctors','/schedules','/attendance'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/doctors/add" class="nav-item <?= is_active('/doctors/add', $currentPath) ?>"><span class="icon">➕</span><span class="label">Add Doctor</span></a>
                <a href="<?= htmlspecialchars($base) ?>/doctors" class="nav-item <?= is_active('/doctors', $currentPath) ?>"><span class="icon">📋</span><span class="label">Doctor List</span></a>
                <a href="<?= htmlspecialchars($base) ?>/doctors/schedule" class="nav-item <?= is_active('/doctors/schedule', $currentPath) ?>"><span class="icon">🗓️</span><span class="label">Doctor Schedule</span></a>
                <a href="<?= htmlspecialchars($base) ?>/doctors/attendance" class="nav-item <?= is_active('/doctors/attendance', $currentPath) ?>"><span class="icon">🕒</span><span class="label">Attendance</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Appointments</div>
            <div class="nav-item js-collapser <?= section_open(['/appointments'], $currentPath) ?>"><a href="#" class="icon">📅</a><span class="label">Appointments</span>
            </div>
            <div class="nav-collapse <?= section_open(['/appointments'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/appointments/add" class="nav-item <?= is_active('/appointments/add', $currentPath) ?>"><span class="icon">➕</span><span class="label">New Appointment</span></a>
                <a href="<?= htmlspecialchars($base) ?>/appointments" class="nav-item <?= is_active('/appointments', $currentPath) ?>"><span class="icon">📅</span><span class="label">Appointment List</span></a>
                <a href="#" class="nav-item"><span class="icon">📆</span><span class="label">Today’s Appointments</span></a>
                <a href="#" class="nav-item"><span class="icon">🚑</span><span class="label">Ambulance Requests</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Medical Records</div>
            <div class="nav-item js-collapser <?= section_open(['/medical-records'], $currentPath) ?>"><a href="#" class="icon">📋</a><span class="label">Medical Records</span>
            </div>
            <div class="nav-collapse <?= section_open(['/medical-records'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/medical-records" class="nav-item <?= is_active('/medical-records', $currentPath) ?>"><span class="icon">📋</span><span class="label">Overview</span></a>
                <a href="<?= htmlspecialchars($base) ?>/medical-records/visits" class="nav-item <?= is_active('/medical-records/visits', $currentPath) ?>"><span class="icon">📜</span><span class="label">Visits</span></a>
                <a href="<?= htmlspecialchars($base) ?>/medical-records/prescriptions" class="nav-item <?= is_active('/medical-records/prescriptions', $currentPath) ?>"><span class="icon">📝</span><span class="label">Prescriptions</span></a>
                <a href="<?= htmlspecialchars($base) ?>/medical-records/labs" class="nav-item <?= is_active('/medical-records/labs', $currentPath) ?>"><span class="icon">🧪</span><span class="label">Lab Reports</span></a>
                <a href="<?= htmlspecialchars($base) ?>/medical-records/imaging" class="nav-item <?= is_active('/medical-records/imaging', $currentPath) ?>"><span class="icon">🩻</span><span class="label">Imaging</span></a>
                <a href="<?= htmlspecialchars($base) ?>/medical-records/allergies" class="nav-item <?= is_active('/medical-records/allergies', $currentPath) ?>"><span class="icon">⚠️</span><span class="label">Allergies</span></a>
                <a href="<?= htmlspecialchars($base) ?>/medical-records/vitals" class="nav-item <?= is_active('/medical-records/vitals', $currentPath) ?>"><span class="icon">❤️</span><span class="label">Vitals</span></a>
                <a href="<?= htmlspecialchars($base) ?>/medical-records/documents" class="nav-item <?= is_active('/medical-records/documents', $currentPath) ?>"><span class="icon">📄</span><span class="label">Documents</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Billing</div>
            <div class="nav-item js-collapser <?= section_open(['/billing'], $currentPath) ?>"><a href="#" class="icon">💳</a><span class="label">Billing</span></div>
            <div class="nav-collapse <?= section_open(['/billing'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/billing/add" class="nav-item <?= is_active('/billing/add', $currentPath) ?>"><span class="icon">➕</span><span class="label">New Invoice</span></a>
                <a href="<?= htmlspecialchars($base) ?>/billing" class="nav-item <?= is_active('/billing', $currentPath) ?>"><span class="icon">📄</span><span class="label">Invoices</span></a>
                <a href="<?= htmlspecialchars($base) ?>/billing/payments" class="nav-item <?= is_active('/billing/payments', $currentPath) ?>"><span class="icon">💵</span><span class="label">Payments</span></a>
                <a href="<?= htmlspecialchars($base) ?>/billing/refunds" class="nav-item <?= is_active('/billing/refunds', $currentPath) ?>"><span class="icon">🔁</span><span class="label">Refunds</span></a>
                <a href="<?= htmlspecialchars($base) ?>/billing/items" class="nav-item <?= is_active('/billing/items', $currentPath) ?>"><span class="icon">🧾</span><span class="label">Items & Services</span></a>
                <a href="<?= htmlspecialchars($base) ?>/billing/estimates" class="nav-item <?= is_active('/billing/estimates', $currentPath) ?>"><span class="icon">🧮</span><span class="label">Estimates</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Laboratory</div>
            <div class="nav-item js-collapser <?= section_open(['/lab','/laboratory'], $currentPath) ?>"><a href="#" class="icon">🧪</a><span class="label">Laboratory</span>
            </div>
            <div class="nav-collapse <?= section_open(['/lab','/laboratory'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/lab" class="nav-item <?= is_active('/lab', $currentPath) ?>"><span class="icon">🧪</span><span class="label">Lab Test List</span></a>
                <a href="#" class="nav-item"><span class="icon">📥</span><span class="label">Lab Requests</span></a>
                <a href="#" class="nav-item"><span class="icon">🧫</span><span class="label">Sample Collection</span></a>
                <a href="#" class="nav-item"><span class="icon">📊</span><span class="label">Lab Reports</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Pharmacy</div>
            <div class="nav-item js-collapser <?= section_open(['/pharmacy'], $currentPath) ?>"><a href="#" class="icon">💊</a><span class="label">Pharmacy</span></div>
            <div class="nav-collapse <?= section_open(['/pharmacy'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/pharmacy/medicines" class="nav-item <?= is_active('/pharmacy/medicines', $currentPath) ?>"><span class="icon">💊</span><span class="label">Medicine List</span></a>
                <a href="<?= htmlspecialchars($base) ?>/pharmacy/stock" class="nav-item <?= is_active('/pharmacy/stock', $currentPath) ?>"><span class="icon">📦</span><span class="label">Stock Management</span></a>
                <a href="<?= htmlspecialchars($base) ?>/pharmacy/sales" class="nav-item <?= is_active('/pharmacy/sales', $currentPath) ?>"><span class="icon">🧾</span><span class="label">POS (Sales)</span></a>
                <a href="#" class="nav-item"><span class="icon">⏳</span><span class="label">Expiry Alerts</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Inventory</div>
            <div class="nav-item js-collapser"><a href="#" class="icon">📦</a><span class="label">Inventory</span></div>
            <div class="nav-collapse">
                <a href="#" class="nav-item"><span class="icon">📦</span><span class="label">Items</span></a>
                <a href="#" class="nav-item"><span class="icon">🏬</span><span class="label">Vendors</span></a>
                <a href="#" class="nav-item"><span class="icon">🧾</span><span class="label">Purchase Orders</span></a>
                <a href="#" class="nav-item"><span class="icon">📈</span><span class="label">Stock Reports</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Finance</div>
            <div class="nav-item js-collapser"><a href="#" class="icon">💼</a><span class="label">Finance</span></div>
            <div class="nav-collapse">
                <a href="#" class="nav-item"><span class="icon">💰</span><span class="label">Daily Collection</span></a>
                <a href="#" class="nav-item"><span class="icon">📈</span><span class="label">Revenue</span></a>
                <a href="#" class="nav-item"><span class="icon">📉</span><span class="label">Expenses</span></a>
                <a href="#" class="nav-item"><span class="icon">🧾</span><span class="label">Salary & Payroll</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Reports</div>
            <div class="nav-item js-collapser"><a href="#" class="icon">📈</a><span class="label">Reports</span></div>
            <div class="nav-collapse">
                <a href="#" class="nav-item"><span class="icon">👤</span><span class="label">Patient Reports</span></a>
                <a href="#" class="nav-item"><span class="icon">📅</span><span class="label">Appointment Reports</span></a>
                <a href="#" class="nav-item"><span class="icon">💳</span><span class="label">Billing Reports</span></a>
                <a href="#" class="nav-item"><span class="icon">🧪</span><span class="label">Lab Reports</span></a>
                <a href="#" class="nav-item"><span class="icon">💊</span><span class="label">Pharmacy Reports</span></a>
                <a href="#" class="nav-item"><span class="icon">📦</span><span class="label">Inventory Reports</span></a>
            </div>
        </div>

        <div class="nav-section">
            <div class="section-title">Settings</div>
            <div class="nav-item js-collapser <?= section_open(['/settings'], $currentPath) ?>"><a href="#" class="icon">⚙️</a><span class="label">Settings</span></div>
            <div class="nav-collapse <?= section_open(['/settings'], $currentPath) ?>">
                <a href="<?= htmlspecialchars($base) ?>/settings" class="nav-item <?= is_active('/settings', $currentPath) ?>"><span class="icon">⚙️</span><span class="label">General Settings</span></a>
                <a href="<?= htmlspecialchars($base) ?>/profile" class="nav-item <?= is_active('/profile', $currentPath) ?>"><span class="icon">👤</span><span class="label">Profile Settings</span></a>
                <a href="<?= htmlspecialchars($base) ?>/backup" class="nav-item <?= is_active('/backup', $currentPath) ?>"><span class="icon">💽</span><span class="label">Database Backup</span></a>
                <a href="<?= htmlspecialchars($base) ?>/logout" class="nav-item"><span class="icon">🚪</span><span class="label">Logout</span></a>
            </div>
        </div>
    </nav>
</aside>
<script>
(function() {
    document.addEventListener('click', function(e) {
        var trigger = e.target.closest('.nav .js-collapser');
        if (!trigger) return;
        var section = trigger.closest('.nav-section');
        if (!section) return;
        trigger.classList.toggle('open');
        section.classList.toggle('open');
        var collapse = section.querySelector('.nav-collapse');
        if (collapse) collapse.classList.toggle('open');
    });

    // Mobile sidebar toggle
    document.addEventListener('click', function(e) {
        var btn = e.target.closest('#toggleSidebar');
        if (!btn) return;
        var sb = document.getElementById('sidebar');
        if (!sb) return;
        sb.classList.toggle('hidden');
    });
})();
</script>
