<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Medical Records - Overview') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3">
          <div>
            <h1 class="h4 mb-1"><i class="fas fa-notes-medical text-primary me-2"></i>Medical Records</h1>
            <div class="text-muted small">Overview of patient clinical data</div>
          </div>
        </div>

        <div class="row g-3">
          <div class="col-12 col-md-6 col-lg-3">
            <a href="<?= htmlspecialchars($base) ?>/medical-records/visits" class="text-decoration-none">
              <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                  <div class="me-3 text-primary"><i class="fas fa-hospital-user fa-2x"></i></div>
                  <div>
                    <div class="fw-semibold">Visits</div>
                    <div class="text-muted small">Encounters & notes</div>
                  </div>
                </div>
              </div>
            </a>
          </div>
          <div class="col-12 col-md-6 col-lg-3">
            <a href="<?= htmlspecialchars($base) ?>/medical-records/prescriptions" class="text-decoration-none">
              <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                  <div class="me-3 text-success"><i class="fas fa-pills fa-2x"></i></div>
                  <div>
                    <div class="fw-semibold">Prescriptions</div>
                    <div class="text-muted small">Medication orders</div>
                  </div>
                </div>
              </div>
            </a>
          </div>
          <div class="col-12 col-md-6 col-lg-3">
            <a href="<?= htmlspecialchars($base) ?>/medical-records/labs" class="text-decoration-none">
              <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                  <div class="me-3 text-danger"><i class="fas fa-vials fa-2x"></i></div>
                  <div>
                    <div class="fw-semibold">Lab Reports</div>
                    <div class="text-muted small">Results & trends</div>
                  </div>
                </div>
              </div>
            </a>
          </div>
          <div class="col-12 col-md-6 col-lg-3">
            <a href="<?= htmlspecialchars($base) ?>/medical-records/imaging" class="text-decoration-none">
              <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                  <div class="me-3 text-info"><i class="fas fa-x-ray fa-2x"></i></div>
                  <div>
                    <div class="fw-semibold">Imaging</div>
                    <div class="text-muted small">Radiology reports</div>
                  </div>
                </div>
              </div>
            </a>
          </div>
          <div class="col-12 col-md-6 col-lg-3">
            <a href="<?= htmlspecialchars($base) ?>/medical-records/allergies" class="text-decoration-none">
              <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                  <div class="me-3 text-warning"><i class="fas fa-allergies fa-2x"></i></div>
                  <div>
                    <div class="fw-semibold">Allergies</div>
                    <div class="text-muted small">Allergy & intolerance</div>
                  </div>
                </div>
              </div>
            </a>
          </div>
          <div class="col-12 col-md-6 col-lg-3">
            <a href="<?= htmlspecialchars($base) ?>/medical-records/vitals" class="text-decoration-none">
              <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                  <div class="me-3 text-secondary"><i class="fas fa-heartbeat fa-2x"></i></div>
                  <div>
                    <div class="fw-semibold">Vitals</div>
                    <div class="text-muted small">BP, Pulse, Temp</div>
                  </div>
                </div>
              </div>
            </a>
          </div>
          <div class="col-12 col-md-6 col-lg-3">
            <a href="<?= htmlspecialchars($base) ?>/medical-records/documents" class="text-decoration-none">
              <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                  <div class="me-3 text-dark"><i class="fas fa-file-medical fa-2x"></i></div>
                  <div>
                    <div class="fw-semibold">Documents</div>
                    <div class="text-muted small">Uploads & files</div>
                  </div>
                </div>
              </div>
            </a>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
