<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Medical Records - Prescriptions') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3">
          <div>
            <h1 class="h4 mb-1"><i class="fas fa-pills text-success me-2"></i>Prescriptions</h1>
            <div class="text-muted small">Medication orders and instructions</div>
          </div>
        </div>

        <div class="card border-0 shadow-sm mb-3">
          <div class="card-body">
            <form class="row g-2">
              <div class="col-12 col-md-3">
                <label class="form-label small text-muted">Patient</label>
                <input type="text" class="form-control form-control-sm" placeholder="Search by name or MRN">
              </div>
              <div class="col-6 col-md-2">
                <label class="form-label small text-muted">From</label>
                <input type="date" class="form-control form-control-sm">
              </div>
              <div class="col-6 col-md-2">
                <label class="form-label small text-muted">To</label>
                <input type="date" class="form-control form-control-sm">
              </div>
              <div class="col-12 col-md-3">
                <label class="form-label small text-muted">Doctor</label>
                <select class="form-select form-select-sm">
                  <option value="">All</option>
                </select>
              </div>
              <div class="col-12 col-md-2 d-flex align-items-end">
                <button class="btn btn-outline-secondary btn-sm me-2" type="submit"><i class="fas fa-filter me-1"></i>Apply</button>
                <a class="btn btn-link btn-sm" href="#">Reset</a>
              </div>
            </form>
          </div>
        </div>

        <div class="card border-0 shadow-sm">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Patient</th>
                    <th>Doctor</th>
                    <th>Drug</th>
                    <th>Dosage</th>
                    <th>Frequency</th>
                    <th>Duration</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td colspan="8" class="text-center text-muted py-4">No prescriptions to show.</td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
