<?php declare(strict_types=1);
// Page-specific styles
$pageStyles = '
    .filter-card {
      background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
      color: white;
      border-radius: 12px;
    }
    .appointment-card {
      transition: transform 0.2s, box-shadow 0.2s;
      border-left: 4px solid #0d6efd;
    }
    .appointment-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .status-badge {
      font-size: 0.85rem;
      padding: 0.4rem 0.8rem;
    }
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Header Section -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-stethoscope text-success me-2"></i>OPD Registrations</h1>
            <p class="text-muted mb-0">Manage outpatient department registrations and appointments</p>
          </div>
          <div class="mt-3 mt-md-0">
            <a href="<?= htmlspecialchars($base) ?>/opd/registration" class="btn btn-success btn-lg shadow-sm">
              <i class="fas fa-plus-circle me-2"></i>New OPD Registration
            </a>
          </div>
        </div>

        <!-- Filter Card -->
        <div class="card filter-card shadow-sm mb-4 border-0">
          <div class="card-body p-4">
            <form method="get" action="<?= htmlspecialchars($base) ?>/opd" class="row g-3">
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-search me-2"></i>Search</label>
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Search by patient name, phone..." class="form-control form-control-lg" />
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-calendar me-2"></i>Date</label>
                <input type="date" name="date" value="<?= htmlspecialchars($date ?? date('Y-m-d')) ?>" class="form-control form-control-lg" />
              </div>
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-user-md me-2"></i>Doctor</label>
                <select name="doctor_id" class="form-select form-select-lg">
                  <option value="">All Doctors</option>
                  <?php foreach (($doctors ?? []) as $doc): ?>
                    <option value="<?= (int)$doc['id'] ?>" <?= (isset($doctor_id) && (int)$doctor_id === (int)$doc['id']) ? 'selected' : '' ?>>
                      <?= htmlspecialchars(($doc['first_name'] ?? '') . ' ' . ($doc['last_name'] ?? '')) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-toggle-on me-2"></i>Status</label>
                <select name="status" class="form-select form-select-lg">
                  <option value="">All Status</option>
                  <option value="Booked" <?= (isset($status) && $status === 'Booked') ? 'selected' : '' ?>>Booked</option>
                  <option value="Completed" <?= (isset($status) && $status === 'Completed') ? 'selected' : '' ?>>Completed</option>
                  <option value="Cancelled" <?= (isset($status) && $status === 'Cancelled') ? 'selected' : '' ?>>Cancelled</option>
                  <option value="NoShow" <?= (isset($status) && $status === 'NoShow') ? 'selected' : '' ?>>No Show</option>
                </select>
              </div>
              <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-light btn-lg w-100 shadow-sm" type="submit">
                  <i class="fas fa-filter me-2"></i>Filter
                </button>
              </div>
            </form>
          </div>
        </div>

        <!-- Appointments Table -->
        <div class="card shadow-sm border-0">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>OPD ID</th>
                    <th>Patient Name</th>
                    <th>Doctor</th>
                    <th>Department</th>
                    <th>Appointment Date & Time</th>
                    <th>Status</th>
                    <th>Registered</th>
                    <th class="text-center">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($appointments)): ?>
                    <?php foreach ($appointments as $apt): 
                      $opdId = 'OPD' . str_pad((string)$apt['id'], 4, '0', STR_PAD_LEFT);
                    ?>
                      <tr>
                        <td><strong class="text-success"><?= htmlspecialchars($opdId) ?></strong></td>
                        <td>
                          <strong><?= htmlspecialchars(($apt['p_first'] ?? '') . ' ' . ($apt['p_last'] ?? '')) ?></strong>
                          <?php if (!empty($apt['p_phone'])): ?>
                            <br><small class="text-muted"><i class="fas fa-phone me-1"></i><?= htmlspecialchars($apt['p_phone']) ?></small>
                          <?php endif; ?>
                        </td>
                        <td>
                          <strong><?= htmlspecialchars(($apt['d_first'] ?? '') . ' ' . ($apt['d_last'] ?? '')) ?></strong>
                          <?php if (!empty($apt['specialty'])): ?>
                            <br><small class="text-muted"><?= htmlspecialchars($apt['specialty']) ?></small>
                          <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($apt['department_name'] ?? 'N/A') ?></td>
                        <td>
                          <?php if (!empty($apt['scheduled_at'])): ?>
                            <strong><?= date('d-m-Y', strtotime($apt['scheduled_at'])) ?></strong>
                            <br><small class="text-muted"><?= date('H:i', strtotime($apt['scheduled_at'])) ?></small>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <span class="badge bg-<?= 
                            ($apt['status'] ?? 'Booked') === 'Completed' ? 'success' : 
                            (($apt['status'] ?? 'Booked') === 'Cancelled' ? 'danger' : 
                            (($apt['status'] ?? 'Booked') === 'NoShow' ? 'warning' : 'primary')) 
                          ?> status-badge">
                            <?= htmlspecialchars($apt['status'] ?? 'Booked') ?>
                          </span>
                        </td>
                        <td>
                          <?php if (!empty($apt['created_at'])): ?>
                            <small><?= date('d-m-Y H:i', strtotime($apt['created_at'])) ?></small>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td class="text-center">
                          <a href="<?= htmlspecialchars($base) ?>/opd/view?id=<?= urlencode((string)$apt['id']) ?>" class="btn btn-sm btn-outline-primary" title="View">
                            <i class="fas fa-eye"></i>
                          </a>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="8" class="text-center text-muted py-5">
                        <i class="fas fa-stethoscope fa-3x d-block mb-3"></i>
                        <h5>No OPD registrations found</h5>
                        <p class="mb-0">Get started by registering a new OPD patient</p>
                        <a href="<?= htmlspecialchars($base) ?>/opd/registration" class="btn btn-success mt-3">
                          <i class="fas fa-plus-circle me-2"></i>New OPD Registration
                        </a>
                      </td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <!-- Pagination -->
        <?php
          $total = (int)($total ?? 0);
          $perPage = (int)($perPage ?? 20);
          $page = (int)($page ?? 1);
          $pages = $perPage > 0 ? (int)ceil($total / $perPage) : 1;
        ?>
        <?php if ($pages > 1): ?>
          <nav class="mt-4" aria-label="OPD pagination">
            <ul class="pagination justify-content-center">
              <?php for ($p = 1; $p <= $pages; $p++): ?>
                <li class="page-item <?= $p === $page ? 'active' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/opd?page=<?= $p ?>&q=<?= urlencode((string)($q ?? '')) ?>&doctor_id=<?= urlencode((string)($doctor_id ?? '')) ?>&status=<?= urlencode((string)($status ?? '')) ?>&date=<?= urlencode((string)($date ?? '')) ?>"><?= $p ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>






