<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'OPD Registration') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
  <style>
    .form-section {
      background: #f8f9fa;
      border-radius: 8px;
      padding: 1.5rem;
      margin-bottom: 1.5rem;
      border-left: 4px solid #0d6efd;
    }
    .section-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: #495057;
      margin-bottom: 1rem;
      padding-bottom: 0.5rem;
      border-bottom: 2px solid #dee2e6;
    }
    .patient-info-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 8px;
      padding: 1rem;
    }
  </style>
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-success text-white">
            <div class="d-flex justify-content-between align-items-center">
              <h2 class="h5 mb-0"><i class="fas fa-stethoscope me-2"></i>OPD Registration</h2>
              <a href="<?= htmlspecialchars($base) ?>/opd" class="btn btn-light btn-sm">
                <i class="fas fa-list me-1"></i>View All Registrations
              </a>
            </div>
          </div>
          <div class="card-body p-4">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? $formError ?? null;
              $formErrors = $_SESSION['form_errors'] ?? $formErrors ?? [];
              $old = $_SESSION['old'] ?? $old ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>
            <?php endif; ?>

            <!-- Patient Information (if pre-selected) -->
            <?php if (!empty($patient)): ?>
              <div class="patient-info-card mb-4">
                <div class="d-flex justify-content-between align-items-center">
                  <div>
                    <h5 class="mb-1"><i class="fas fa-user me-2"></i><?= htmlspecialchars(($patient['first_name'] ?? '') . ' ' . ($patient['last_name'] ?? '')) ?></h5>
                    <div class="small">
                      <span class="me-3"><i class="fas fa-phone me-1"></i><?= htmlspecialchars($patient['phone'] ?? 'N/A') ?></span>
                      <span><i class="fas fa-venus-mars me-1"></i><?= htmlspecialchars($patient['gender'] ?? 'N/A') ?></span>
                    </div>
                  </div>
                  <a href="<?= htmlspecialchars($base) ?>/patients/add" class="btn btn-light btn-sm">
                    <i class="fas fa-plus me-1"></i>New Patient
                  </a>
                </div>
              </div>
            <?php endif; ?>
            
            <form method="post" action="<?= htmlspecialchars($base) ?>/opd/store" id="opdForm">
              <input type="hidden" name="patient_id" value="<?= (int)($patient_id ?? ($old['patient_id'] ?? 0)) ?>">
              
              <!-- Patient Selection -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-user-injured me-2"></i>Patient Information</div>
                <?php if (empty($patient)): ?>
                  <div class="mb-3">
                    <label class="form-label fw-semibold">Select Patient <span class="text-danger">*</span></label>
                    <select name="patient_id" id="patientSelect" class="form-select form-select-lg" required>
                      <option value="">-- Search and Select Patient --</option>
                      <?php foreach (($patients ?? []) as $p): ?>
                        <option value="<?= (int)$p['id'] ?>" <?= (isset($old['patient_id']) && (int)$old['patient_id'] === (int)$p['id']) ? 'selected' : '' ?>>
                          <?= htmlspecialchars(($p['first_name'] ?? '') . ' ' . ($p['last_name'] ?? '')) ?> 
                          <?php if (!empty($p['phone'])): ?>
                            (<?= htmlspecialchars($p['phone']) ?>)
                          <?php endif; ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                    <?php if (!empty($formErrors['patient_id'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['patient_id']) ?></div><?php endif; ?>
                    <div class="mt-2">
                      <a href="<?= htmlspecialchars($base) ?>/patients/add" class="btn btn-outline-primary btn-sm" target="_blank">
                        <i class="fas fa-plus-circle me-1"></i>Register New Patient
                      </a>
                    </div>
                  </div>
                <?php else: ?>
                  <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Patient:</strong> <?= htmlspecialchars(($patient['first_name'] ?? '') . ' ' . ($patient['last_name'] ?? '')) ?>
                    <a href="<?= htmlspecialchars($base) ?>/opd/registration" class="btn btn-sm btn-outline-primary ms-2">
                      <i class="fas fa-edit me-1"></i>Change Patient
                    </a>
                  </div>
                <?php endif; ?>
              </div>

              <!-- Doctor & Department Selection -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-user-md me-2"></i>Doctor & Department</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Department</label>
                    <select name="department_id" id="departmentSelect" class="form-select form-select-lg">
                      <option value="">-- Select Department (Optional) --</option>
                      <?php foreach (($departments ?? []) as $dept): ?>
                        <option value="<?= (int)$dept['id'] ?>"><?= htmlspecialchars($dept['name']) ?></option>
                      <?php endforeach; ?>
                    </select>
                    <small class="text-muted">Selecting department will filter doctors</small>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Consulting Doctor <span class="text-danger">*</span></label>
                    <select name="doctor_id" id="doctorSelect" class="form-select form-select-lg" required>
                      <option value="">-- Select Doctor --</option>
                      <?php foreach (($doctors ?? []) as $d): ?>
                        <option value="<?= (int)$d['id'] ?>" 
                                data-department="<?= (int)($d['department_id'] ?? 0) ?>"
                                data-specialty="<?= htmlspecialchars($d['specialty'] ?? '') ?>"
                                <?= (isset($old['doctor_id']) && (int)$old['doctor_id'] === (int)$d['id']) ? 'selected' : '' ?>>
                          <?= htmlspecialchars(($d['first_name'] ?? '') . ' ' . ($d['last_name'] ?? '')) ?>
                          <?php if (!empty($d['specialty'])): ?>
                            - <?= htmlspecialchars($d['specialty']) ?>
                          <?php endif; ?>
                          <?php if (!empty($d['department'])): ?>
                            (<?= htmlspecialchars($d['department']) ?>)
                          <?php endif; ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                    <?php if (!empty($formErrors['doctor_id'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['doctor_id']) ?></div><?php endif; ?>
                  </div>
                </div>
              </div>

              <!-- Appointment Details -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-calendar-alt me-2"></i>Appointment Details</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Appointment Date <span class="text-danger">*</span></label>
                    <input type="date" name="appointment_date" id="appointmentDate" value="<?= htmlspecialchars($old['appointment_date'] ?? date('Y-m-d')) ?>" class="form-control form-control-lg" required min="<?= date('Y-m-d') ?>" />
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Appointment Time <span class="text-danger">*</span></label>
                    <input type="time" name="appointment_time" id="appointmentTime" value="<?= htmlspecialchars($old['appointment_time'] ?? date('H:i')) ?>" class="form-control form-control-lg" required />
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Status</label>
                    <select name="status" class="form-select form-select-lg">
                      <option value="Booked" <?= (!isset($old['status']) || $old['status'] === 'Booked') ? 'selected' : '' ?>>Booked</option>
                      <option value="Completed" <?= (isset($old['status']) && $old['status'] === 'Completed') ? 'selected' : '' ?>>Completed</option>
                      <option value="Cancelled" <?= (isset($old['status']) && $old['status'] === 'Cancelled') ? 'selected' : '' ?>>Cancelled</option>
                      <option value="NoShow" <?= (isset($old['status']) && $old['status'] === 'NoShow') ? 'selected' : '' ?>>No Show</option>
                    </select>
                  </div>
                </div>
                <div class="mb-3">
                  <label class="form-label fw-semibold">Notes / Chief Complaint</label>
                  <textarea name="notes" class="form-control" rows="3" placeholder="Enter patient's chief complaint, symptoms, or any notes..."><?= htmlspecialchars($old['notes'] ?? '') ?></textarea>
                </div>
              </div>

              <div class="d-flex justify-content-between align-items-center mt-4 pt-3 border-top">
                <div>
                  <small class="text-muted">
                    <i class="fas fa-info-circle me-1"></i>OPD registration will create an appointment record
                  </small>
                </div>
                <div class="d-flex gap-2">
                  <a class="btn btn-secondary btn-lg" href="<?= htmlspecialchars($base) ?>/patients">
                    <i class="fas fa-times me-2"></i>Cancel
                  </a>
                  <button class="btn btn-success btn-lg" type="submit">
                    <i class="fas fa-check-circle me-2"></i>Register OPD
                  </button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Combine date and time into scheduled_at
    document.getElementById('opdForm')?.addEventListener('submit', function(e) {
      const date = document.getElementById('appointmentDate')?.value;
      const time = document.getElementById('appointmentTime')?.value;
      if (date && time) {
        const scheduledAt = date + 'T' + time;
        const hiddenInput = document.createElement('input');
        hiddenInput.type = 'hidden';
        hiddenInput.name = 'scheduled_at';
        hiddenInput.value = scheduledAt.replace('T', ' ');
        this.appendChild(hiddenInput);
      }
    });

    // Filter doctors by department
    document.getElementById('departmentSelect')?.addEventListener('change', function() {
      const deptId = this.value;
      const doctorSelect = document.getElementById('doctorSelect');
      if (doctorSelect) {
        const options = doctorSelect.querySelectorAll('option');
        options.forEach(opt => {
          if (opt.value === '') {
            opt.style.display = 'block';
          } else {
            const optDept = opt.getAttribute('data-department');
            if (deptId === '' || optDept === deptId) {
              opt.style.display = 'block';
            } else {
              opt.style.display = 'none';
            }
          }
        });
        doctorSelect.value = '';
      }
    });
  </script>
</body>
</html>






