<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'OPD Registration Details') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-stethoscope text-success me-2"></i>OPD Registration Details</h1>
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= htmlspecialchars($base) ?>/opd">OPD Registrations</a></li>
                <li class="breadcrumb-item active">Details</li>
              </ol>
            </nav>
          </div>
          <div>
            <a class="btn btn-secondary" href="<?= htmlspecialchars($base) ?>/opd">
              <i class="fas fa-arrow-left me-2"></i>Back
            </a>
          </div>
        </div>

        <div class="row g-4">
          <!-- OPD Information -->
          <div class="col-md-6">
            <div class="card shadow-sm border-0">
              <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>OPD Registration Information</h5>
              </div>
              <div class="card-body">
                <table class="table table-borderless mb-0">
                  <tr>
                    <th width="40%">OPD ID</th>
                    <td><strong class="text-success">OPD<?= str_pad((string)($appointment['id'] ?? 0), 4, '0', STR_PAD_LEFT) ?></strong></td>
                  </tr>
                  <tr>
                    <th>Appointment Date</th>
                    <td>
                      <?php if (!empty($appointment['scheduled_at'])): ?>
                        <strong><?= date('d-m-Y', strtotime($appointment['scheduled_at'])) ?></strong>
                      <?php else: ?>
                        <span class="text-muted">N/A</span>
                      <?php endif; ?>
                    </td>
                  </tr>
                  <tr>
                    <th>Appointment Time</th>
                    <td>
                      <?php if (!empty($appointment['scheduled_at'])): ?>
                        <strong><?= date('H:i A', strtotime($appointment['scheduled_at'])) ?></strong>
                      <?php else: ?>
                        <span class="text-muted">N/A</span>
                      <?php endif; ?>
                    </td>
                  </tr>
                  <tr>
                    <th>Status</th>
                    <td>
                      <span class="badge bg-<?= 
                        ($appointment['status'] ?? 'Booked') === 'Completed' ? 'success' : 
                        (($appointment['status'] ?? 'Booked') === 'Cancelled' ? 'danger' : 
                        (($appointment['status'] ?? 'Booked') === 'NoShow' ? 'warning' : 'primary')) 
                      ?>">
                        <?= htmlspecialchars($appointment['status'] ?? 'Booked') ?>
                      </span>
                    </td>
                  </tr>
                  <tr>
                    <th>Registered On</th>
                    <td><?= !empty($appointment['created_at']) ? date('d-m-Y H:i A', strtotime($appointment['created_at'])) : 'N/A' ?></td>
                  </tr>
                </table>
              </div>
            </div>
          </div>

          <!-- Patient Information -->
          <div class="col-md-6">
            <div class="card shadow-sm border-0">
              <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="fas fa-user-injured me-2"></i>Patient Information</h5>
              </div>
              <div class="card-body">
                <table class="table table-borderless mb-0">
                  <tr>
                    <th width="40%">Patient ID</th>
                    <td><strong class="text-primary">P<?= str_pad((string)($appointment['patient_id'] ?? 0), 3, '0', STR_PAD_LEFT) ?></strong></td>
                  </tr>
                  <tr>
                    <th>Name</th>
                    <td><strong><?= htmlspecialchars(($appointment['p_first'] ?? '') . ' ' . ($appointment['p_last'] ?? '')) ?></strong></td>
                  </tr>
                  <tr>
                    <th>Gender</th>
                    <td><?= htmlspecialchars($appointment['p_gender'] ?? 'N/A') ?></td>
                  </tr>
                  <?php if (!empty($appointment['p_dob'])): 
                    $age = date_diff(date_create($appointment['p_dob']), date_create('today'))->y;
                  ?>
                    <tr>
                      <th>Date of Birth</th>
                      <td><?= date('d-m-Y', strtotime($appointment['p_dob'])) ?> (<?= $age ?> years)</td>
                    </tr>
                  <?php endif; ?>
                  <tr>
                    <th>Phone</th>
                    <td><?= htmlspecialchars($appointment['p_phone'] ?? 'N/A') ?></td>
                  </tr>
                  <tr>
                    <th>Email</th>
                    <td><?= htmlspecialchars($appointment['p_email'] ?? 'N/A') ?></td>
                  </tr>
                </table>
                <div class="mt-3">
                  <a href="<?= htmlspecialchars($base) ?>/patients/view?id=<?= urlencode((string)($appointment['patient_id'] ?? 0)) ?>" class="btn btn-sm btn-outline-primary">
                    <i class="fas fa-eye me-1"></i>View Patient Details
                  </a>
                </div>
              </div>
            </div>
          </div>

          <!-- Doctor Information -->
          <div class="col-md-6">
            <div class="card shadow-sm border-0">
              <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="fas fa-user-md me-2"></i>Doctor Information</h5>
              </div>
              <div class="card-body">
                <table class="table table-borderless mb-0">
                  <tr>
                    <th width="40%">Doctor Name</th>
                    <td><strong><?= htmlspecialchars(($appointment['d_first'] ?? '') . ' ' . ($appointment['d_last'] ?? '')) ?></strong></td>
                  </tr>
                  <tr>
                    <th>Specialty</th>
                    <td><?= htmlspecialchars($appointment['specialty'] ?? 'N/A') ?></td>
                  </tr>
                  <tr>
                    <th>Department</th>
                    <td><?= htmlspecialchars($appointment['department_name'] ?? 'N/A') ?></td>
                  </tr>
                  <?php if (!empty($appointment['d_phone'])): ?>
                    <tr>
                      <th>Phone</th>
                      <td><?= htmlspecialchars($appointment['d_phone']) ?></td>
                    </tr>
                  <?php endif; ?>
                  <?php if (!empty($appointment['d_email'])): ?>
                    <tr>
                      <th>Email</th>
                      <td><?= htmlspecialchars($appointment['d_email']) ?></td>
                    </tr>
                  <?php endif; ?>
                </table>
              </div>
            </div>
          </div>

          <!-- Notes -->
          <?php if (!empty($appointment['notes'])): ?>
            <div class="col-md-6">
              <div class="card shadow-sm border-0">
                <div class="card-header bg-light">
                  <h5 class="mb-0"><i class="fas fa-sticky-note me-2"></i>Notes / Chief Complaint</h5>
                </div>
                <div class="card-body">
                  <p class="mb-0"><?= nl2br(htmlspecialchars($appointment['notes'])) ?></p>
                </div>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>






