<?php declare(strict_types=1);
// Page-specific styles
// $pageStyles = '
//     .form-section {
//       background: #f8f9fa;
//       border-radius: 8px;
//       padding: 1.5rem;
//       margin-bottom: 1.5rem;
//       border-left: 4px solid #0d6efd;
//     }
//     .section-title {
//       font-size: 1.1rem;
//       font-weight: 600;
//       color: #495057;
//       margin-bottom: 1rem;
//       padding-bottom: 0.5rem;
//       border-bottom: 2px solid #dee2e6;
//     }
//     .info-badge {
//       background: #e7f3ff;
//       color: #0d6efd;
//       padding: 0.5rem 1rem;
//       border-radius: 6px;
//       font-size: 0.9rem;
//       display: inline-block;
//       margin-bottom: 1rem;
//     }
// ';

// Page-specific scripts
// $pageScripts = '
//     // Auto-calculate age from DOB
//     document.getElementById(\'dob\')?.addEventListener(\'change\', function() {
//       const dob = this.value;
//       if (dob) {
//         const birthDate = new Date(dob);
//         const today = new Date();
//         let age = today.getFullYear() - birthDate.getFullYear();
//         const monthDiff = today.getMonth() - birthDate.getMonth();
//         if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate())) {
//           age--;
//         }
//         document.getElementById(\'ageDisplay\').value = age + \' years\';
//       } else {
//         document.getElementById(\'ageDisplay\').value = \'\';
//       }
//     });

//     // Phone number validation
//     document.querySelector(\'input[name="phone"]\')?.addEventListener(\'input\', function() {
//       this.value = this.value.replace(/\\D/g, \'\').slice(0, 10);
//     });
// ';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-primary text-white">
            <div class="d-flex justify-content-between align-items-center">
              <h2 class="h5 mb-0"><i class="fas fa-user-plus me-2"></i>Add New Patient</h2>
              <div class="info-badge text-white" style="background: rgba(255,255,255,0.2);">
                <i class="fas fa-info-circle me-1"></i>Patient ID will be auto-generated
              </div>
            </div>
          </div>
          <div class="card-body p-4">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? $formError ?? null;
              $formErrors = $_SESSION['form_errors'] ?? $formErrors ?? [];
              $old = $_SESSION['old'] ?? $old ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>
            <?php endif; ?>
            
            <form method="post" action="<?= htmlspecialchars($base) ?>/patients/store" id="patientForm">
              <!-- Personal Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-user me-2"></i>Personal Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">First Name <span class="text-danger">*</span></label>
                    <input name="first_name" value="<?= htmlspecialchars($old['first_name'] ?? '') ?>" class="form-control form-control-lg" required placeholder="Enter first name" autofocus />
                    <?php if (!empty($formErrors['first_name'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['first_name']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Last Name <span class="text-danger">*</span></label>
                    <input name="last_name" value="<?= htmlspecialchars($old['last_name'] ?? '') ?>" class="form-control form-control-lg" required placeholder="Enter last name" />
                    <?php if (!empty($formErrors['last_name'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['last_name']) ?></div><?php endif; ?>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-4 mb-3">
                    <label class="form-label fw-semibold">Gender <span class="text-danger">*</span></label>
                    <select name="gender" class="form-select form-select-lg" required>
                      <option value="">-- Select Gender --</option>
                      <option value="Male" <?= (isset($old['gender']) && $old['gender'] === 'Male') ? 'selected' : '' ?>>Male</option>
                      <option value="Female" <?= (isset($old['gender']) && $old['gender'] === 'Female') ? 'selected' : '' ?>>Female</option>
                      <option value="Other" <?= (isset($old['gender']) && $old['gender'] === 'Other') ? 'selected' : '' ?>>Other</option>
                    </select>
                  </div>
                  <div class="col-md-4 mb-3">
                    <label class="form-label fw-semibold">Date of Birth</label>
                    <input type="date" name="dob" value="<?= htmlspecialchars($old['dob'] ?? '') ?>" class="form-control form-control-lg" max="<?= date('Y-m-d') ?>" id="dob" />
                    <small class="text-muted">Age will be calculated automatically</small>
                  </div>
                  <div class="col-md-4 mb-3">
                    <label class="form-label fw-semibold">Age</label>
                    <input type="text" class="form-control form-control-lg" id="ageDisplay" readonly placeholder="Auto-calculated" style="background-color: #e9ecef;" />
                  </div>
                </div>
              </div>

              <!-- Contact Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-address-card me-2"></i>Contact Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Mobile Number <span class="text-danger">*</span></label>
                    <div class="input-group input-group-lg">
                      <span class="input-group-text"><i class="fas fa-phone"></i></span>
                      <input type="tel" name="phone" value="<?= htmlspecialchars($old['phone'] ?? '') ?>" class="form-control" required placeholder="e.g., 9876543210" pattern="[0-9]{10}" maxlength="10" />
                    </div>
                    <?php if (!empty($formErrors['phone'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['phone']) ?></div><?php endif; ?>
                    <small class="text-muted">Enter 10-digit mobile number</small>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Email Address</label>
                    <div class="input-group input-group-lg">
                      <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                      <input type="email" name="email" value="<?= htmlspecialchars($old['email'] ?? '') ?>" class="form-control" placeholder="patient@example.com" />
                    </div>
                    <?php if (!empty($formErrors['email'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['email']) ?></div><?php endif; ?>
                  </div>
                </div>
                <div class="mb-3">
                  <label class="form-label fw-semibold">Complete Address</label>
                  <textarea name="address" class="form-control" rows="3" placeholder="Enter complete address with city, state, and PIN code"><?= htmlspecialchars($old['address'] ?? '') ?></textarea>
                </div>
              </div>

              <!-- Important Notes -->
              <div class="alert alert-info">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Note:</strong> After registration, you can:
                <ul class="mb-0 mt-2">
                  <li>Create <strong>OPD Appointment</strong> for outpatient consultation</li>
                  <li>Create <strong>IPD Admission</strong> for inpatient treatment</li>
                  <li>Patient type (OPD/IPD/Emergency) will be automatically determined based on appointments/admissions</li>
                </ul>
              </div>

              <div class="d-flex justify-content-between align-items-center mt-4 pt-3 border-top">
                <div>
                  <small class="text-muted">
                    <i class="fas fa-shield-alt me-1"></i>All information will be kept confidential
                  </small>
                </div>
                <div class="d-flex gap-2">
                  <a class="btn btn-secondary btn-lg" href="<?= htmlspecialchars($base) ?>/patients">
                    <i class="fas fa-times me-2"></i>Cancel
                  </a>
                  <button class="btn btn-primary btn-lg" type="submit">
                    <i class="fas fa-save me-2"></i>Register Patient
                  </button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>
