<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Discharge Summary') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-primary text-white">
            <h2 class="h5 mb-0"><i class="fas fa-file-medical me-2"></i>Discharge Summary</h2>
          </div>
          <div class="card-body">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? $formError ?? null;
              $formErrors = $_SESSION['form_errors'] ?? $formErrors ?? [];
              $old = $_SESSION['old'] ?? $old ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>
            <?php endif; ?>

            <form action="<?= htmlspecialchars($base) ?>/patients/addDischargeSummary" method="POST">
              <div class="row">
                <div class="col-md-6 mb-3">
                  <label class="form-label">Patient Name</label>
                  <input type="text" class="form-control" id="patientName" name="patientName" value="<?= htmlspecialchars($old['patient_name'] ?? '') ?>" required>
                  <?php if (!empty($formErrors['patient_name'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['patient_name']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label">Patient ID</label>
                  <input type="text" class="form-control" id="patientID" name="patientID" value="<?= htmlspecialchars($old['patient_id'] ?? '') ?>" required>
                  <?php if (!empty($formErrors['patient_id'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['patient_id']) ?></div><?php endif; ?>
                </div>
              </div>

              <div class="row">
                <div class="col-md-6 mb-3">
                  <label class="form-label">Admission Date</label>
                  <input type="date" class="form-control" id="admissionDate" name="admissionDate" value="<?= htmlspecialchars($old['admission_date'] ?? '') ?>" required>
                  <?php if (!empty($formErrors['admission_date'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['admission_date']) ?></div><?php endif; ?>
                </div>
                <div class="col-md-6 mb-3">
                  <label class="form-label">Discharge Date</label>
                  <input type="date" class="form-control" id="dischargeDate" name="dischargeDate" value="<?= htmlspecialchars($old['discharge_date'] ?? '') ?>" required>
                  <?php if (!empty($formErrors['discharge_date'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['discharge_date']) ?></div><?php endif; ?>
                </div>
              </div>

              <div class="mb-3">
                <label class="form-label">Diagnosis</label>
                <textarea class="form-control" id="diagnosis" name="diagnosis" rows="3" required><?= htmlspecialchars($old['diagnosis'] ?? '') ?></textarea>
                <?php if (!empty($formErrors['diagnosis'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['diagnosis']) ?></div><?php endif; ?>
              </div>
              <div class="mb-3">
                <label class="form-label">Treatment Given</label>
                <textarea class="form-control" id="treatment" name="treatment" rows="5" required><?= htmlspecialchars($old['treatment'] ?? '') ?></textarea>
                <?php if (!empty($formErrors['treatment'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['treatment']) ?></div><?php endif; ?>
              </div>
              <div class="mb-3">
                <label class="form-label">Medications Prescribed</label>
                <textarea class="form-control" id="medications" name="medications" rows="3" required><?= htmlspecialchars($old['medications'] ?? '') ?></textarea>
                <?php if (!empty($formErrors['medications'])): ?><div class="text-danger small mt-1"><?= htmlspecialchars($formErrors['medications']) ?></div><?php endif; ?>
              </div>
              <div class="mb-3">
                <label class="form-label">Follow-up Instructions</label>
                <textarea class="form-control" id="followUp" name="followUp" rows="3"><?= htmlspecialchars($old['follow_up'] ?? '') ?></textarea>
              </div>

              <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Submit Discharge Summary</button>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
