<?php declare(strict_types=1);
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Discharged Patients') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="d-flex align-items-center justify-content-between mb-3">
          <h1 class="h4 mb-0"><i class="fas fa-user-check me-2"></i>Discharged Patients</h1>
        </div>
        <div class="card border-0 shadow-sm">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-striped table-hover mb-0">
                <thead class="table-light">
                  <tr>
                    <th>#</th>
                    <th>Patient</th>
                    <th>Doctor</th>
                    <th>Department</th>
                    <th>Admission Date</th>
                    <th>Discharge Date</th>
                    <th>Diagnosis</th>
                    <th>Bed</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($items)): ?>
                    <?php foreach ($items as $idx => $row): ?>
                      <tr>
                        <td><?= (int)$idx + 1 + ((int)($page ?? 1) - 1) * (int)($perPage ?? 20) ?></td>
                        <td><?= htmlspecialchars(trim(($row['p_first'] ?? '') . ' ' . ($row['p_last'] ?? ''))) ?></td>
                        <td><?= htmlspecialchars(trim(($row['d_first'] ?? '') . ' ' . ($row['d_last'] ?? ''))) ?></td>
                        <td><?= htmlspecialchars($row['department_name'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['admitted_at'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['discharged_at'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['diagnosis'] ?? '') ?></td>
                        <td>
                          <?php
                            $bed = [];
                            if (!empty($row['ward'])) { $bed[] = $row['ward']; }
                            if (!empty($row['bed_number'])) { $bed[] = 'Bed ' . $row['bed_number']; }
                            echo htmlspecialchars(implode(' - ', $bed));
                          ?>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="8" class="text-center text-muted py-4">No discharged patients found.</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
          <?php if (($total ?? 0) > ($perPage ?? 20)): ?>
          <div class="card-footer d-flex justify-content-between align-items-center">
            <div class="text-muted">Total: <?= (int)$total ?></div>
            <nav>
              <?php
                $totalPages = (int)ceil(max(1, (int)$total) / max(1, (int)$perPage));
                $current = max(1, (int)$page);
                $prev = max(1, $current - 1);
                $next = min($totalPages, $current + 1);
              ?>
              <ul class="pagination mb-0">
                <li class="page-item <?= $current <= 1 ? 'disabled' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/patients/discharged?page=<?= $prev ?>">Previous</a>
                </li>
                <li class="page-item disabled"><span class="page-link">Page <?= $current ?> of <?= $totalPages ?></span></li>
                <li class="page-item <?= $current >= $totalPages ? 'disabled' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/patients/discharged?page=<?= $next ?>">Next</a>
                </li>
              </ul>
            </nav>
          </div>
          <?php endif; ?>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
