<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Edit Patient') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/admin.css" rel="stylesheet">
  <link href="<?= htmlspecialchars($base) ?>/public/assets/css/sidebar.css" rel="stylesheet">
  <style>
    .form-section {
      background: #f8f9fa;
      border-radius: 8px;
      padding: 1.5rem;
      margin-bottom: 1.5rem;
    }
    .section-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: #495057;
      margin-bottom: 1rem;
      padding-bottom: 0.5rem;
      border-bottom: 2px solid #dee2e6;
    }
  </style>
</head>
<body>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <div class="card border-0 shadow-sm">
          <div class="card-header bg-primary text-white">
            <h2 class="h5 mb-0"><i class="fas fa-edit me-2"></i>Edit Patient</h2>
          </div>
          <div class="card-body p-4">
            <?php
              if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
              $formError = $_SESSION['form_error'] ?? $formError ?? null;
              $formErrors = $_SESSION['form_errors'] ?? $formErrors ?? [];
              $old = $_SESSION['old'] ?? $old ?? null;
              if (isset($_SESSION['form_error'])) { unset($_SESSION['form_error']); }
              if (isset($_SESSION['form_errors'])) { unset($_SESSION['form_errors']); }
              if (isset($_SESSION['old'])) { unset($_SESSION['old']); }
              if (!empty($formError)): ?>
              <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i><?= htmlspecialchars($formError) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
              </div>
            <?php endif; ?>
            
            <form method="post" action="<?= htmlspecialchars($base) ?>/patients/update">
              <input type="hidden" name="id" value="<?= (int)($patient['id'] ?? 0) ?>">
              <!-- Personal Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-user me-2"></i>Personal Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">First Name <span class="text-danger">*</span></label>
                    <input name="first_name" value="<?= htmlspecialchars($old['first_name'] ?? $patient['first_name'] ?? '') ?>" class="form-control form-control-lg" required />
                    <?php if (!empty($formErrors['first_name'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['first_name']) ?></div><?php endif; ?>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Last Name <span class="text-danger">*</span></label>
                    <input name="last_name" value="<?= htmlspecialchars($old['last_name'] ?? $patient['last_name'] ?? '') ?>" class="form-control form-control-lg" required />
                    <?php if (!empty($formErrors['last_name'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['last_name']) ?></div><?php endif; ?>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-4 mb-3">
                    <label class="form-label fw-semibold">Gender</label>
                    <select name="gender" class="form-select form-select-lg">
                      <option value="">-- Select Gender --</option>
                      <option value="Male" <?= ((isset($old['gender']) && $old['gender'] === 'Male') || (!isset($old['gender']) && isset($patient['gender']) && $patient['gender'] === 'Male')) ? 'selected' : '' ?>>Male</option>
                      <option value="Female" <?= ((isset($old['gender']) && $old['gender'] === 'Female') || (!isset($old['gender']) && isset($patient['gender']) && $patient['gender'] === 'Female')) ? 'selected' : '' ?>>Female</option>
                      <option value="Other" <?= ((isset($old['gender']) && $old['gender'] === 'Other') || (!isset($old['gender']) && isset($patient['gender']) && $patient['gender'] === 'Other')) ? 'selected' : '' ?>>Other</option>
                    </select>
                  </div>
                  <div class="col-md-4 mb-3">
                    <label class="form-label fw-semibold">Date of Birth</label>
                    <input type="date" name="dob" value="<?= htmlspecialchars($old['dob'] ?? $patient['dob'] ?? '') ?>" class="form-control form-control-lg" max="<?= date('Y-m-d') ?>" />
                  </div>
                  <div class="col-md-4 mb-3">
                    <label class="form-label fw-semibold">Phone</label>
                    <input type="tel" name="phone" value="<?= htmlspecialchars($old['phone'] ?? $patient['phone'] ?? '') ?>" class="form-control form-control-lg" />
                    <?php if (!empty($formErrors['phone'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['phone']) ?></div><?php endif; ?>
                  </div>
                </div>
              </div>

              <!-- Contact Information -->
              <div class="form-section">
                <div class="section-title"><i class="fas fa-address-card me-2"></i>Contact Information</div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Email</label>
                    <input type="email" name="email" value="<?= htmlspecialchars($old['email'] ?? $patient['email'] ?? '') ?>" class="form-control form-control-lg" />
                    <?php if (!empty($formErrors['email'])): ?><div class="text-danger small mt-1"><i class="fas fa-exclamation-circle me-1"></i><?= htmlspecialchars($formErrors['email']) ?></div><?php endif; ?>
                  </div>
                </div>
                <div class="mb-3">
                  <label class="form-label fw-semibold">Address</label>
                  <textarea name="address" class="form-control" rows="3"><?= htmlspecialchars($old['address'] ?? $patient['address'] ?? '') ?></textarea>
                </div>
              </div>

              <div class="d-flex justify-content-end gap-2 mt-4">
                <a class="btn btn-secondary btn-lg" href="<?= htmlspecialchars($base) ?>/patients">
                  <i class="fas fa-times me-2"></i>Cancel
                </a>
                <button class="btn btn-primary btn-lg" type="submit">
                  <i class="fas fa-save me-2"></i>Update Patient
                </button>
              </div>
            </form>
          </div>
        </div>
      </main>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>






