<?php declare(strict_types=1);
// Page-specific styles
$pageStyles = '
    .filter-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 12px;
    }
    .table th {
      background-color: #f8f9fa;
      font-weight: 600;
      white-space: nowrap;
    }
    .patient-id {
      font-weight: 700;
      color: #0d6efd;
    }
';

// Page-specific scripts
$pageScripts = '
    function printCard(id) {
      window.open(\'' . htmlspecialchars($base ?? '') . '/patients/print?id=\' + id, \'_blank\');
    }
';

// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <?php
          if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
          $flashSuccess = $_SESSION['flash_success'] ?? null;
          if (isset($_SESSION['flash_success'])) { unset($_SESSION['flash_success']); }
          if (!empty($flashSuccess)): ?>
          <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($flashSuccess) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Header Section -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
          <div>
            <h1 class="h3 mb-2 fw-bold"><i class="fas fa-user-injured text-primary me-2"></i>Patients Management</h1>
            <p class="text-muted mb-0">Manage patient records and information</p>
          </div>
          <div class="mt-3 mt-md-0">
            <a href="<?= htmlspecialchars($base) ?>/patients/add" class="btn btn-primary btn-lg shadow-sm">
              <i class="fas fa-plus-circle me-2"></i>Add New Patient
            </a>
          </div>
        </div>

        <!-- Filter Card -->
        <div class="card filter-card shadow-sm mb-4 border-0">
          <div class="card-body p-4">
            <form method="get" action="<?= htmlspecialchars($base) ?>/patients" class="row g-3">
              <div class="col-md-3">
                <label class="form-label text-white fw-semibold"><i class="fas fa-search me-2"></i>Search</label>
                <input name="q" value="<?= htmlspecialchars($q ?? '') ?>" placeholder="Search by name, phone, email..." class="form-control form-control-lg" />
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-venus-mars me-2"></i>Gender</label>
                <select name="gender" class="form-select form-select-lg">
                  <option value="">All</option>
                  <option value="Male" <?= (isset($gender) && $gender === 'Male') ? 'selected' : '' ?>>Male</option>
                  <option value="Female" <?= (isset($gender) && $gender === 'Female') ? 'selected' : '' ?>>Female</option>
                  <option value="Other" <?= (isset($gender) && $gender === 'Other') ? 'selected' : '' ?>>Other</option>
                </select>
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-hospital me-2"></i>Patient Type</label>
                <select name="patient_type" class="form-select form-select-lg">
                  <option value="">All Types</option>
                  <option value="OPD" <?= (isset($patient_type) && $patient_type === 'OPD') ? 'selected' : '' ?>>OPD</option>
                  <option value="IPD" <?= (isset($patient_type) && $patient_type === 'IPD') ? 'selected' : '' ?>>IPD</option>
                  <option value="Emergency" <?= (isset($patient_type) && $patient_type === 'Emergency') ? 'selected' : '' ?>>Emergency</option>
                </select>
              </div>
              <div class="col-md-2">
                <label class="form-label text-white fw-semibold"><i class="fas fa-toggle-on me-2"></i>Status</label>
                <select name="status" class="form-select form-select-lg">
                  <option value="">All Status</option>
                  <option value="Active" <?= (isset($status) && $status === 'Active') ? 'selected' : '' ?>>Active</option>
                  <option value="Admitted" <?= (isset($status) && $status === 'Admitted') ? 'selected' : '' ?>>Admitted</option>
                  <option value="Discharged" <?= (isset($status) && $status === 'Discharged') ? 'selected' : '' ?>>Discharged</option>
                </select>
              </div>
              <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-light btn-lg w-100 shadow-sm" type="submit">
                  <i class="fas fa-filter me-2"></i>Filter
                </button>
              </div>
            </form>
          </div>
        </div>

        <!-- Patients Table -->
        <div class="card shadow-sm border-0">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Gender</th>
                    <th>Age</th>
                    <th>Mobile</th>
                    <th>Type</th>
                    <th>Dept</th>
                    <th>Doctor</th>
                    <th>Admit Date</th>
                    <th>Ward-Room-Bed</th>
                    <th>Status</th>
                    <th class="text-center">Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($patients)): ?>
                    <?php foreach ($patients as $p): 
                      $age = !empty($p['dob']) ? date_diff(date_create($p['dob']), date_create('today'))->y : null;
                      $patientId = 'P' . str_pad((string)$p['id'], 3, '0', STR_PAD_LEFT);
                      $genderShort = !empty($p['gender']) ? ($p['gender'] === 'Male' ? 'M' : ($p['gender'] === 'Female' ? 'F' : 'O')) : '-';
                    ?>
                      <tr>
                        <td><span class="patient-id"><?= htmlspecialchars($patientId) ?></span></td>
                        <td><strong><?= htmlspecialchars(($p['first_name'] ?? '') . ' ' . ($p['last_name'] ?? '')) ?></strong></td>
                        <td><?= htmlspecialchars($genderShort) ?></td>
                        <td><?= $age !== null ? $age . ' yrs' : '-' ?></td>
                        <td><?= htmlspecialchars($p['phone'] ?? '-') ?></td>
                        <td>
                          <span class="badge bg-<?= ($p['patient_type'] ?? 'OPD') === 'IPD' ? 'primary' : (($p['patient_type'] ?? 'OPD') === 'Emergency' ? 'danger' : 'success') ?>">
                            <?= htmlspecialchars($p['patient_type'] ?? 'OPD') ?>
                          </span>
                        </td>
                        <td><?= htmlspecialchars($p['department_name'] ?? '-') ?></td>
                        <td>
                          <?php if (!empty($p['doctor_name'])): ?>
                            <small><?= htmlspecialchars($p['doctor_name']) ?></small>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if (!empty($p['admission_date'])): ?>
                            <?= date('d-m-Y', strtotime($p['admission_date'])) ?>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if (!empty($p['bed_info'])): ?>
                            <small class="text-primary"><?= htmlspecialchars($p['bed_info']) ?></small>
                          <?php else: ?>
                            <span class="text-muted">-</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <span class="badge bg-<?= ($p['status'] ?? 'Active') === 'Admitted' ? 'warning' : (($p['status'] ?? 'Active') === 'Discharged' ? 'secondary' : 'success') ?>">
                            <?= htmlspecialchars($p['status'] ?? 'Active') ?>
                          </span>
                        </td>
                        <td class="text-center">
                          <div class="btn-group" role="group">
                            <a href="<?= htmlspecialchars($base) ?>/patients/view?id=<?= urlencode((string)$p['id']) ?>" class="btn btn-sm btn-outline-primary" title="View">
                              <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?= htmlspecialchars($base) ?>/patients/edit?id=<?= urlencode((string)$p['id']) ?>" class="btn btn-sm btn-outline-secondary" title="Edit">
                              <i class="fas fa-edit"></i>
                            </a>
                            <form method="post" action="<?= htmlspecialchars($base) ?>/patients/delete" style="display:inline-block" onsubmit="return confirm('Are you sure you want to delete this patient?');">
                              <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
                              <button type="submit" class="btn btn-sm btn-outline-danger" title="Delete">
                                <i class="fas fa-trash"></i>
                              </button>
                            </form>
                            <?php if (($p['patient_type'] ?? 'OPD') === 'OPD'): ?>
                              <a href="<?= htmlspecialchars($base) ?>/appointments/add?patient_id=<?= urlencode((string)$p['id']) ?>" class="btn btn-sm btn-outline-success" title="OPD">
                                <i class="fas fa-stethoscope"></i>
                              </a>
                            <?php endif; ?>
                            <?php if (($p['patient_type'] ?? 'OPD') !== 'IPD'): ?>
                              <a href="<?= htmlspecialchars($base) ?>/admissions/add?patient_id=<?= urlencode((string)$p['id']) ?>" class="btn btn-sm btn-outline-info" title="IPD">
                                <i class="fas fa-bed"></i>
                              </a>
                            <?php endif; ?>
                            <button class="btn btn-sm btn-outline-dark" onclick="printCard(<?= (int)$p['id'] ?>)" title="Print Card">
                              <i class="fas fa-print"></i>
                            </button>
                          </div>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="12" class="text-center text-muted py-5">
                        <i class="fas fa-user-injured fa-3x d-block mb-3"></i>
                        <h5>No patients found</h5>
                        <p class="mb-0">Get started by adding your first patient</p>
                        <a href="<?= htmlspecialchars($base) ?>/patients/add" class="btn btn-primary mt-3">
                          <i class="fas fa-plus-circle me-2"></i>Add New Patient
                        </a>
                      </td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <!-- Pagination -->
        <?php
          $total = (int)($total ?? 0);
          $perPage = (int)($perPage ?? 20);
          $page = (int)($page ?? 1);
          $pages = $perPage > 0 ? (int)ceil($total / $perPage) : 1;
        ?>
        <?php if ($pages > 1): ?>
          <nav class="mt-4" aria-label="Patients pagination">
            <ul class="pagination justify-content-center">
              <?php for ($p = 1; $p <= $pages; $p++): ?>
                <li class="page-item <?= $p === $page ? 'active' : '' ?>">
                  <a class="page-link" href="<?= htmlspecialchars($base) ?>/patients?page=<?= $p ?>&q=<?= urlencode((string)($q ?? '')) ?>&gender=<?= urlencode((string)($gender ?? '')) ?>&patient_type=<?= urlencode((string)($patient_type ?? '')) ?>&status=<?= urlencode((string)($status ?? '')) ?>"><?= $p ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>
