<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Patient Card') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    @media print {
      body { margin: 0; padding: 0; }
      .no-print { display: none !important; }
      .card { border: 2px solid #000; page-break-inside: avoid; }
    }
    .patient-card {
      width: 100%;
      max-width: 400px;
      margin: 20px auto;
      border: 2px solid #000;
      border-radius: 8px;
      padding: 20px;
      background: white;
    }
    .card-header {
      text-align: center;
      border-bottom: 2px solid #000;
      padding-bottom: 15px;
      margin-bottom: 15px;
    }
    .hospital-name {
      font-size: 24px;
      font-weight: bold;
      margin-bottom: 5px;
    }
    .card-title {
      font-size: 18px;
      font-weight: 600;
      margin-top: 10px;
    }
    .patient-info {
      margin: 15px 0;
    }
    .info-row {
      display: flex;
      justify-content: space-between;
      padding: 8px 0;
      border-bottom: 1px solid #ddd;
    }
    .info-label {
      font-weight: 600;
      color: #333;
    }
    .info-value {
      color: #000;
    }
    .barcode-area {
      text-align: center;
      margin-top: 20px;
      padding-top: 15px;
      border-top: 2px solid #000;
    }
    .patient-id-large {
      font-size: 28px;
      font-weight: bold;
      color: #0d6efd;
      margin: 10px 0;
    }
  </style>
</head>
<body>
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <!-- Print Button -->
        <div class="text-center mb-3 no-print">
          <button onclick="window.print()" class="btn btn-primary btn-lg">
            <i class="fas fa-print me-2"></i>Print Card
          </button>
          <a href="<?= htmlspecialchars($base ?? '') ?>/patients" class="btn btn-secondary btn-lg ms-2">
            <i class="fas fa-arrow-left me-2"></i>Back to List
          </a>
        </div>

        <!-- Patient Card -->
        <div class="patient-card">
          <div class="card-header">
            <div class="hospital-name">HOSPITAL ERP</div>
            <div style="font-size: 14px; color: #666;">Patient Identification Card</div>
            <div class="card-title">PATIENT CARD</div>
          </div>

          <div class="patient-info">
            <div class="info-row">
              <span class="info-label">Patient ID:</span>
              <span class="info-value"><strong>P<?= str_pad((string)($patient['id'] ?? 0), 3, '0', STR_PAD_LEFT) ?></strong></span>
            </div>
            <div class="info-row">
              <span class="info-label">Name:</span>
              <span class="info-value"><strong><?= htmlspecialchars(($patient['first_name'] ?? '') . ' ' . ($patient['last_name'] ?? '')) ?></strong></span>
            </div>
            <div class="info-row">
              <span class="info-label">Gender:</span>
              <span class="info-value"><?= htmlspecialchars($patient['gender'] ?? 'N/A') ?></span>
            </div>
            <?php if (!empty($patient['dob'])): 
              $age = date_diff(date_create($patient['dob']), date_create('today'))->y;
            ?>
              <div class="info-row">
                <span class="info-label">Date of Birth:</span>
                <span class="info-value"><?= date('d-m-Y', strtotime($patient['dob'])) ?></span>
              </div>
              <div class="info-row">
                <span class="info-label">Age:</span>
                <span class="info-value"><?= $age ?> years</span>
              </div>
            <?php endif; ?>
            <?php if (!empty($patient['phone'])): ?>
              <div class="info-row">
                <span class="info-label">Phone:</span>
                <span class="info-value"><?= htmlspecialchars($patient['phone']) ?></span>
              </div>
            <?php endif; ?>
            <?php if (!empty($patient['email'])): ?>
              <div class="info-row">
                <span class="info-label">Email:</span>
                <span class="info-value" style="font-size: 12px;"><?= htmlspecialchars($patient['email']) ?></span>
              </div>
            <?php endif; ?>
            <?php if (!empty($patient['address'])): ?>
              <div class="info-row">
                <span class="info-label">Address:</span>
                <span class="info-value" style="font-size: 12px; text-align: right; max-width: 60%;"><?= nl2br(htmlspecialchars($patient['address'])) ?></span>
              </div>
            <?php endif; ?>
            <div class="info-row">
              <span class="info-label">Registered:</span>
              <span class="info-value"><?= !empty($patient['created_at']) ? date('d-m-Y', strtotime($patient['created_at'])) : 'N/A' ?></span>
            </div>
          </div>

          <div class="barcode-area">
            <div class="patient-id-large">P<?= str_pad((string)($patient['id'] ?? 0), 3, '0', STR_PAD_LEFT) ?></div>
            <div style="font-size: 12px; color: #666; margin-top: 10px;">
              This card must be presented at every visit
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script>
    // Auto print when page loads (optional)
    // window.onload = function() {
    //   window.print();
    // }
  </script>
</body>
</html>






