<?php declare(strict_types=1);
// Include header
require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'header.php';
?>
  <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'navbar.php'; ?>
  <div class="container-fluid">
    <div class="row">
      <?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'sidebar.php'; ?>
      <main class="content p-4">
        <a href="<?= htmlspecialchars($base) ?>/patients" class="btn btn-link">&larr; Back to Patients</a>
        <div class="row justify-content-center mt-2">
          <div class="col-12 col-lg-8">
            <div class="card border-0 shadow-sm">
              <div class="card-body p-4">
                <h1 class="h4 mb-4">Patient Details</h1>
                <div class="row g-3">
                  <div class="col-md-6">
                    <div class="text-secondary">First Name</div>
                    <div class="fw-semibold"><?= htmlspecialchars($patient['first_name'] ?? '') ?></div>
                  </div>
                  <div class="col-md-6">
                    <div class="text-secondary">Last Name</div>
                    <div class="fw-semibold"><?= htmlspecialchars($patient['last_name'] ?? '') ?></div>
                  </div>
                  <div class="col-md-4">
                    <div class="text-secondary">Gender</div>
                    <div class="fw-semibold"><?= htmlspecialchars($patient['gender'] ?? '') ?></div>
                  </div>
                  <div class="col-md-4">
                    <div class="text-secondary">DOB</div>
                    <div class="fw-semibold"><?= htmlspecialchars($patient['dob'] ?? '') ?></div>
                  </div>
                  <div class="col-md-4">
                    <div class="text-secondary">Phone</div>
                    <div class="fw-semibold"><?= htmlspecialchars($patient['phone'] ?? '') ?></div>
                  </div>
                  <div class="col-md-6">
                    <div class="text-secondary">Email</div>
                    <div class="fw-semibold"><?= htmlspecialchars($patient['email'] ?? '') ?></div>
                  </div>
                  <div class="col-12">
                    <div class="text-secondary">Address</div>
                    <div class="fw-semibold"><?= nl2br(htmlspecialchars($patient['address'] ?? '')) ?></div>
                  </div>
                  <div class="col-12">
                    <div class="text-secondary">Registered</div>
                    <div class="fw-semibold"><?= htmlspecialchars($patient['created_at'] ?? '') ?></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </main>
    </div>
  </div>
<?php require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include' . DIRECTORY_SEPARATOR . 'footer.php'; ?>

