<?php declare(strict_types=1); ?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h1 class="h4 mb-1"><?= htmlspecialchars($title ?? 'Add Pharmacy Sale') ?></h1>
    <div class="text-muted">Create a new sale / receipt</div>
  </div>
  <div>
    <a href="<?= htmlspecialchars($base) ?>/pharmacy/sales" class="btn btn-secondary">Back to Sales</a>
  </div>
</div>

<div class="card card-elevated">
  <div class="card-body">
    <form method="post" action="<?= htmlspecialchars($base) ?>/pharmacy/sales/add">
      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label">Patient</label>
          <select name="patient_id" class="form-select">
            <?php if (!empty($patients) && is_array($patients)): ?>
              <option value="">-- Select patient --</option>
              <?php foreach ($patients as $p): ?>
                <option value="<?= (int)($p['id'] ?? 0) ?>"><?= htmlspecialchars(($p['p_first'] ?? '') . ' ' . ($p['p_last'] ?? '')) ?></option>
              <?php endforeach; ?>
            <?php else: ?>
              <option value="">No patients available</option>
            <?php endif; ?>
          </select>
        </div>

        <div class="col-md-6 mb-3">
          <label class="form-label">Sale Date</label>
          <input type="date" name="sale_date" value="<?= htmlspecialchars(date('Y-m-d')) ?>" class="form-control" />
        </div>
      </div>

      <div class="mb-3">
        <label class="form-label">Items</label>
        <textarea name="items" class="form-control" rows="4" placeholder="One item per line: medicine_id|qty|price"></textarea>
        <div class="form-text">Format: <code>medicine_id|quantity|price</code> per line (the controller will parse this).</div>
      </div>

      <div class="row">
        <div class="col-md-4 mb-3">
          <label class="form-label">Subtotal</label>
          <input type="number" step="0.01" name="subtotal" class="form-control" />
        </div>
        <div class="col-md-4 mb-3">
          <label class="form-label">Discount</label>
          <input type="number" step="0.01" name="discount" class="form-control" />
        </div>
        <div class="col-md-4 mb-3">
          <label class="form-label">Total</label>
          <input type="number" step="0.01" name="total" class="form-control" />
        </div>
      </div>

      <div class="text-end">
        <button type="submit" class="btn btn-primary">Save Sale</button>
        <a href="<?= htmlspecialchars($base) ?>/pharmacy/sales" class="btn btn-secondary ms-2">Cancel</a>
      </div>
    </form>
  </div>
</div>
