<?php declare(strict_types=1); ?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h1 class="h4 mb-1"><?= htmlspecialchars($title ?? 'Pharmacy Sales') ?></h1>
    <div class="text-muted">List of completed sales and receipts</div>
  </div>
  <div>
    <a href="<?= htmlspecialchars($base) ?>/pharmacy/sales/add" class="btn btn-primary">New Sale</a>
  </div>
</div>

<div class="card card-elevated">
  <div class="card-body">
    <?php if (empty($sales)): ?>
      <div class="text-muted">No sales found.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th>#</th>
              <th>Date</th>
              <th>Patient</th>
              <th>Total</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($sales as $row): ?>
              <tr>
                <td><?= (int)($row['id'] ?? 0) ?></td>
                <td><?= htmlspecialchars((string)($row['sale_date'] ?? '')) ?></td>
                <td><?= htmlspecialchars(trim(($row['p_first'] ?? '') . ' ' . ($row['p_last'] ?? ''))) ?></td>
                <td><?= number_format((float)($row['total'] ?? 0), 2) ?></td>
                <td class="text-end">
                  <a href="<?= htmlspecialchars($base) ?>/pharmacy/sales/view?id=<?= urlencode((string)($row['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-secondary">View</a>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>
