<?php
declare(strict_types=1);

class Medicine extends Model
{
    public function all(): array
    {
        $stmt = $this->db()->query("SELECT id, name, sku, unit, price FROM medicines ORDER BY name");
        return $stmt->fetchAll();
    }

    public function create(array $data): int
    {
        $stmt = $this->db()->prepare("INSERT INTO medicines (name, sku, unit, price) VALUES (:name, :sku, :unit, :price)");
        $stmt->execute([
            ':name' => $data['name'] ?? '',
            ':sku' => $data['sku'] ?? null,
            ':unit' => $data['unit'] ?? null,
            ':price' => (float)($data['price'] ?? 0),
        ]);
        return (int)$this->db()->lastInsertId();
    }

    public function getPrice(int $id): float
    {
        $stmt = $this->db()->prepare('SELECT price FROM medicines WHERE id = :id');
        $stmt->execute([':id' => $id]);
        $val = $stmt->fetchColumn();
        return $val !== false ? (float)$val : 0.0;
    }

    public function saleItemsByRef(string $ref): array
    {
        $sql = "SELECT sm.qty, m.name, m.price
                FROM stock_movements sm
                INNER JOIN medicines m ON m.id = sm.medicine_id
                WHERE sm.ref = :ref AND sm.type = 'OUT'";
        $stmt = $this->db()->prepare($sql);
        $stmt->execute([':ref' => $ref]);
        return $stmt->fetchAll();
    }
}
