<?php
declare(strict_types=1);

class Sale extends Model
{
    public function all(): array
    {
        $sql = "SELECT s.id, s.sale_date, s.total, p.first_name AS p_first, p.last_name AS p_last
                FROM pharmacy_sales s
                LEFT JOIN patients p ON p.id = s.patient_id
                ORDER BY s.id DESC";
        $stmt = $this->db()->query($sql);
        return $stmt->fetchAll();
    }

    public function find(int $id): ?array
    {
        $stmt = $this->db()->prepare("SELECT s.*, p.first_name AS p_first, p.last_name AS p_last
                                      FROM pharmacy_sales s
                                      LEFT JOIN patients p ON p.id = s.patient_id
                                      WHERE s.id = :id");
        $stmt->execute([':id' => $id]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public function create(?int $patientId, float $total): int
    {
        $stmt = $this->db()->prepare("INSERT INTO pharmacy_sales (patient_id, sale_date, total) VALUES (:pid, NOW(), :total)");
        $stmt->execute([':pid' => $patientId, ':total' => $total]);
        return (int)$this->db()->lastInsertId();
    }

    public function patients(): array
    {
        $stmt = $this->db()->query("SELECT id, first_name, last_name FROM patients ORDER BY last_name, first_name");
        return $stmt->fetchAll();
    }
}
